package com.xebialabs.xlrelease.api.internal;

import com.xebialabs.xlrelease.utils.TenantContext$;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Response;
import org.springframework.stereotype.Controller;

import java.net.URI;
import java.net.URISyntaxException;

@Path("/docs")
@Controller
public class DocsResource {

    @GET
    @Path("/{version:[0-9]+\\.[0-9]+}/{path:.*}")
    public Response redirectToDocs(@PathParam("version") String version,
                                   @PathParam("path") String path,
                                   @Context HttpServletRequest _request,
                                   @Context HttpServletResponse _response) throws URISyntaxException {
        // DO NOT use response.sendRedirect, it conflicts with UrlRedirectRewriteFilter
        String location;
        if (TenantContext$.MODULE$.isSystemTenant()) {
            location = "https://docs.digital.ai/release/docs/" + version + "/" + path;
        } else {
            // if needed we can get the original host with request.getHeader("Referer") and replace it in the next line
            location = "https://docs.digital.ai/release/docs/saas/" + path;
        }
        return Response.status(HttpServletResponse.SC_FOUND).location(new URI(location)).build();
    }

    @GET
    @Path("/@doc.version@/{path:.*}")
    public Response redirectToLatestDocs(@PathParam("path") String path) throws URISyntaxException {
        String location;
        if (TenantContext$.MODULE$.isSystemTenant()) {
            location = "https://docs.digital.ai/release/docs/" + path;
        } else {
            location = "https://docs.digital.ai/release/docs/saas/" + path;
        }
        return Response.status(HttpServletResponse.SC_FOUND).location(new URI(location)).build();
    }

}
