package com.xebialabs.xlrelease.pluginmanager

import com.xebialabs.plugin.manager.config.{PluginManagerProperties, Repository, Server}
import com.xebialabs.plugin.manager.config.impl.PluginManagerPropertiesImpl.RepositoryImpl.NexusMetadataArtifactImpl
import com.xebialabs.plugin.manager.config.impl.PluginManagerPropertiesImpl.{RepositoryImpl, ServerImpl}
import com.xebialabs.plugin.manager.config.impl.PluginManagerPropertiesImpl.ServerImpl.{CredentialsImpl, ProxyImpl}

import java.util
import scala.jdk.CollectionConverters._

class XlrPluginManagerProps(
                             serverType: String,
                             url: String,
                             username: String,
                             password: String,
                             proxyHost: String,
                             proxyPort: Integer,
                             proxyUsername: String,
                             proxyPassword: String,
                             repositoryType: String,
                             serverRef: String,
                             nexusRepositoryId: String,
                             nexusGroupId: String,
                             nexusMetadataArtifactGroupId: String,
                             nexusMetadataArtifactArtifactId: String,
                             xlComponent: String,
                             enabled: String
                           ) extends PluginManagerProperties {

  var repository: RepositoryImpl = _
  var nexusMetadataArtifact: NexusMetadataArtifactImpl = _
  var proxy: ProxyImpl = _
  var proxyCredentials: CredentialsImpl = _
  var server: ServerImpl = _
  var serverCredentials: CredentialsImpl = _

    nexusMetadataArtifact = new NexusMetadataArtifactImpl
    nexusMetadataArtifact.setArtifactId(nexusMetadataArtifactArtifactId)
    nexusMetadataArtifact.setGroupId(nexusMetadataArtifactGroupId)

    repository = new RepositoryImpl
    repository.setName("xlr-official")
    repository.setEnabled(enabled)
    repository.setNexusGroupId(nexusGroupId)
    repository.setNexusRepositoryId(nexusRepositoryId)
    repository.setRepositoryType(repositoryType)
    repository.setServerRef(serverRef)
    repository.setXlComponent(xlComponent)
    repository.setNexusMetadataArtifact(nexusMetadataArtifact)

    if (proxyUsername != null && proxyPassword != null) {
      proxyCredentials = new CredentialsImpl
      proxyCredentials.setUsername(proxyUsername)
      proxyCredentials.setPassword(proxyPassword)
    }

    if (proxyHost != null && proxyPort != null) {
      proxy = new ProxyImpl
      proxy.setHost(proxyHost)
      proxy.setPort(proxyPort)
      if (proxyCredentials != null) {
        proxy.setCredentials(proxyCredentials)
      }
    }

    serverCredentials = new CredentialsImpl
    serverCredentials.setUsername(username)
    serverCredentials.setPassword(password)

    server = new ServerImpl
    server.setName("xebialabs-plugins")
    server.setUrl(url)
    server.setServerType(serverType)
    if (proxy != null) {
      server.setProxy(proxy)
    }
    server.setCredentials(serverCredentials)

  override def getRepositories: util.List[_ <: Repository] = List(repository).asJava

  override def getServers: util.List[_ <: Server] = List(server).asJava

}