/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.service.accountlock;

import com.xebialabs.deployit.exception.NotFoundException;
import com.xebialabs.xlrelease.config.XlrConfig;
import com.xebialabs.xlrelease.domain.UserProfile;
import com.xebialabs.xlrelease.domain.events.AccountLockedEvent;
import com.xebialabs.xlrelease.domain.events.AccountUnlockAndFailedAttemptsResetEvent;
import com.xebialabs.xlrelease.domain.events.AccountUnlockEvent;
import com.xebialabs.xlrelease.domain.events.AccountUnlockedAfterSuccessfulLoginEvent;
import com.xebialabs.xlrelease.domain.events.AuthenticationFailureLockEvent;
import com.xebialabs.xlrelease.domain.events.AutoLockThresholdNotReachedEvent;
import com.xebialabs.xlrelease.domain.events.FailedLoginAttemptEvent;
import com.xebialabs.xlrelease.domain.events.XLReleaseEvent;
import com.xebialabs.xlrelease.events.EventBus;
import com.xebialabs.xlrelease.service.UserProfileService;
import com.xebialabs.xlrelease.service.Users;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import java.util.Date;
import org.slf4j.Marker;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Isolation;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Tuple2;
import scala.concurrent.duration.FiniteDuration;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@Service
@ScalaSignature(bytes="\u0006\u0005\u0005Ug\u0001B\u000b\u0017\u0001\u0005B\u0001\u0002\r\u0001\u0003\u0002\u0003\u0006I!\r\u0005\to\u0001\u0011\t\u0011)A\u0005q!AA\b\u0001B\u0001B\u0003%Q\b\u0003\u0005D\u0001\t\u0005\t\u0015!\u0003E\u0011\u00159\u0005\u0001\"\u0001I\u0011\u001dy\u0005A1A\u0005\nACa\u0001\u0016\u0001!\u0002\u0013\t\u0006bB+\u0001\u0005\u0004%IA\u0016\u0005\u0007?\u0002\u0001\u000b\u0011B,\t\u000f\u0001\u0004!\u0019!C\u0005C\"1Q\r\u0001Q\u0001\n\tDQA\u001a\u0001\u0005\u0002\u001dDq!!\u0012\u0001\t\u0013\t9\u0005C\u0004\u0002b\u0001!I!a\u0019\t\u000f\u0005e\u0004\u0001\"\u0003\u0002|!9\u0011Q\u0014\u0001\u0005\n\u0005}\u0005bBAW\u0001\u0011\u0005\u0011q\u0016\u0005\b\u0003g\u0003A\u0011AA[\u0011\u001d\tI\f\u0001C\u0001\u0003wCq!!1\u0001\t\u0003\t\u0019M\u0001\u000fBG\u000e|WO\u001c;M_\u000e\\\u0007K]8uK\u000e$\u0018n\u001c8TKJ4\u0018nY3\u000b\u0005]A\u0012aC1dG>,h\u000e\u001e7pG.T!!\u0007\u000e\u0002\u000fM,'O^5dK*\u00111\u0004H\u0001\nq2\u0014X\r\\3bg\u0016T!!\b\u0010\u0002\u0013a,'-[1mC\n\u001c(\"A\u0010\u0002\u0007\r|Wn\u0001\u0001\u0014\u0007\u0001\u0011\u0003\u0006\u0005\u0002$M5\tAEC\u0001&\u0003\u0015\u00198-\u00197b\u0013\t9CE\u0001\u0004B]f\u0014VM\u001a\t\u0003S9j\u0011A\u000b\u0006\u0003W1\nQa\u001d7gi)T\u0011!L\u0001\tOJL'P\u001f7fI&\u0011qF\u000b\u0002\b\u0019><w-\u001b8h\u0003%AHN]\"p]\u001aLw\r\u0005\u00023k5\t1G\u0003\u000255\u000511m\u001c8gS\u001eL!AN\u001a\u0003\u0013ac'oQ8oM&<\u0017AE;tKJ\u0004&o\u001c4jY\u0016\u001cVM\u001d<jG\u0016\u0004\"!\u000f\u001e\u000e\u0003aI!a\u000f\r\u0003%U\u001bXM\u001d)s_\u001aLG.Z*feZL7-Z\u0001\tKZ,g\u000e\u001e\"vgB\u0011a(Q\u0007\u0002\u007f)\u0011\u0001IG\u0001\u0007KZ,g\u000e^:\n\u0005\t{$\u0001C#wK:$()^:\u0002\u001fU\u001cXM]:SKB|7/\u001b;pef\u0004\"!O#\n\u0005\u0019C\"!B+tKJ\u001c\u0018A\u0002\u001fj]&$h\bF\u0003J\u00172ke\n\u0005\u0002K\u00015\ta\u0003C\u00031\u000b\u0001\u0007\u0011\u0007C\u00038\u000b\u0001\u0007\u0001\bC\u0003=\u000b\u0001\u0007Q\bC\u0003D\u000b\u0001\u0007A)A\tNCb4\u0015-\u001b7fI\u0006#H/Z7qiN,\u0012!\u0015\t\u0003GIK!a\u0015\u0013\u0003\u0007%sG/\u0001\nNCb4\u0015-\u001b7fI\u0006#H/Z7qiN\u0004\u0013AF1dG>,h\u000e\u001e'pG.|W\u000f\u001e#ve\u0006$\u0018n\u001c8\u0016\u0003]\u0003\"\u0001W/\u000e\u0003eS!AW.\u0002\u0011\u0011,(/\u0019;j_:T!\u0001\u0018\u0013\u0002\u0015\r|gnY;se\u0016tG/\u0003\u0002_3\nqa)\u001b8ji\u0016$UO]1uS>t\u0017aF1dG>,h\u000e\u001e'pG.|W\u000f\u001e#ve\u0006$\u0018n\u001c8!\u0003U\t7mY8v]RdunY6pkR,e.\u00192mK\u0012,\u0012A\u0019\t\u0003G\rL!\u0001\u001a\u0013\u0003\u000f\t{w\u000e\\3b]\u00061\u0012mY2pk:$Hj\\2l_V$XI\\1cY\u0016$\u0007%A\nsK\u000e|'\u000f\u001a$bS2,G-\u0011;uK6\u0004H\u000f\u0006\u0002i]B\u0011\u0011\u000e\\\u0007\u0002U*\u00111NG\u0001\u0007I>l\u0017-\u001b8\n\u00055T'aC+tKJ\u0004&o\u001c4jY\u0016DQa\u001c\u0007A\u0002A\f\u0001\"^:fe:\fW.\u001a\t\u0003cbt!A\u001d<\u0011\u0005M$S\"\u0001;\u000b\u0005U\u0004\u0013A\u0002\u001fs_>$h(\u0003\u0002xI\u00051\u0001K]3eK\u001aL!!\u001f>\u0003\rM#(/\u001b8h\u0015\t9H\u0005\u000b\n\ry\u0006E\u00111CA\f\u00033\t\u0019#!\n\u00020\u0005E\u0002cA?\u0002\u000e5\taPC\u0002\u0000\u0003\u0003\t!\"\u00198o_R\fG/[8o\u0015\u0011\t\u0019!!\u0002\u0002\u0017Q\u0014\u0018M\\:bGRLwN\u001c\u0006\u0005\u0003\u000f\tI!A\btaJLgn\u001a4sC6,wo\u001c:l\u0015\t\tY!A\u0002pe\u001eL1!a\u0004\u007f\u00055!&/\u00198tC\u000e$\u0018n\u001c8bY\u0006)a/\u00197vK\u0006\u0012\u0011QC\u0001 q2\u0014(+\u001a9pg&$xN]=Ue\u0006t7/Y2uS>tW*\u00198bO\u0016\u0014\u0018a\u00039s_B\fw-\u0019;j_:$#!a\u0007\n\t\u0005u\u0011qD\u0001\t%\u0016\u000bV+\u0013*F\t*\u0019\u0011\u0011\u0005@\u0002\u0017A\u0013x\u000e]1hCRLwN\\\u0001\nSN|G.\u0019;j_:$#!a\n\n\t\u0005%\u00121F\u0001\u000f%\u0016\u000bEiX\"P\u001b6KE\u000bV#E\u0015\r\tiC`\u0001\n\u0013N|G.\u0019;j_:\fQB\\8S_2d'-Y2l\r>\u0014HFAA\u001aG\t\t)\u0004\u0005\u0003\u00028\u0005\u0005SBAA\u001d\u0015\u0011\tY$!\u0010\u0002\u0013\u0015D8-\u001a9uS>t'bAA 9\u0005AA-\u001a9m_fLG/\u0003\u0003\u0002D\u0005e\"!\u0005(pi\u001a{WO\u001c3Fq\u000e,\u0007\u000f^5p]\u0006\t2-\u00197dk2\fG/\u001a(foN#\u0018\r^3\u0015\u0019\u0005%\u0013qJA*\u0003/\nY&a\u0018\u0011\u000b\r\nY%\u00152\n\u0007\u00055CE\u0001\u0004UkBdWM\r\u0005\u0007\u0003#j\u0001\u0019A)\u0002\u0019\r,(O]3oi\u000e{WO\u001c;\t\r\u0005US\u00021\u0001c\u00035\u0019WO\u001d:f]RdunY6fI\"1\u0011\u0011L\u0007A\u0002\t\f1b\u001d5pk2$'+Z:fi\"1\u0011QL\u0007A\u0002E\u000b\u0001#\\1y\r\u0006LG.\u001a3BiR,W\u000e\u001d;\t\u000b=l\u0001\u0019\u00019\u0002\u001f1|wm\u0015;bi\u0016\u001c\u0005.\u00198hKN$B\"!\u001a\u0002l\u00055\u0014qNA9\u0003k\u00022aIA4\u0013\r\tI\u0007\n\u0002\u0005+:LG\u000fC\u0003p\u001d\u0001\u0007\u0001\u000f\u0003\u0004\u0002R9\u0001\r!\u0015\u0005\u0007\u0003+r\u0001\u0019\u00012\t\r\u0005Md\u00021\u0001R\u0003!qWm^\"pk:$\bBBA<\u001d\u0001\u0007!-A\u0005oK^dunY6fI\u0006\u00012\u000f[8vY\u0012\u001c6.\u001b9Va\u0012\fG/\u001a\u000b\bE\u0006u\u0014qPAM\u0011\u0019\t)f\u0004a\u0001E\"9\u0011\u0011Q\bA\u0002\u0005\r\u0015\u0001\u00047bgR4\u0015-\u001b7fI\u0006#\b#B\u0012\u0002\u0006\u0006%\u0015bAADI\t1q\n\u001d;j_:\u0004B!a#\u0002\u00166\u0011\u0011Q\u0012\u0006\u0005\u0003\u001f\u000b\t*\u0001\u0003vi&d'BAAJ\u0003\u0011Q\u0017M^1\n\t\u0005]\u0015Q\u0012\u0002\u0005\t\u0006$X\rC\u0004\u0002\u001c>\u0001\r!!#\u0002'UtGn\\2l)\"\u0014Xm\u001d5pY\u0012$\u0016.\\3\u0002'\u001d,G/T5okR,7OU3nC&t\u0017N\\4\u0015\r\u0005\u0005\u0016qUAU!\r\u0019\u00131U\u0005\u0004\u0003K##\u0001\u0002'p]\u001eDq!!!\u0011\u0001\u0004\tI\tC\u0004\u0002,B\u0001\r!!#\u0002\u00079|w/A\bjg\u0006\u001b7m\\;oi2{7m[3e)\r\u0011\u0017\u0011\u0017\u0005\u0006_F\u0001\r\u0001]\u0001%e\u0016\u001cX\r\u001e$bS2,G-\u0011;uK6\u0004Ho]!gi\u0016\u00148+^2dKN\u001cHj\\4j]R!\u0011QMA\\\u0011\u0015y'\u00031\u0001q\u00035)h\u000e\\8dW\u0006\u001b7m\\;oiR!\u0011QMA_\u0011\u0019\tyl\u0005a\u0001Q\u0006YQo]3s!J|g-\u001b7f\u0003\u0015\u0002XO\u00197jg\"\fU\u000f\u001e5f]RL7-\u0019;j_:4\u0015-\u001b7ve\u0016dunY6Fm\u0016tG\u000f\u0006\u0003\u0002f\u0005\u0015\u0007\"B8\u0015\u0001\u0004\u0001\bf\u0001\u0001\u0002JB!\u00111ZAi\u001b\t\tiM\u0003\u0003\u0002P\u0006\u0015\u0011AC:uKJ,w\u000e^=qK&!\u00111[Ag\u0005\u001d\u0019VM\u001d<jG\u0016\u0004")
public class AccountLockProtectionService
implements Logging {
    private final UserProfileService userProfileService;
    private final EventBus eventBus;
    private final Users usersRepository;
    private final int MaxFailedAttempts;
    private final FiniteDuration accountLockoutDuration;
    private final boolean accountLockoutEnabled;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        AccountLockProtectionService accountLockProtectionService = this;
        synchronized (accountLockProtectionService) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        if (!this.bitmap$trans$0) {
            return this.grizzled$slf4j$Logging$$_logger$lzycompute();
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    private int MaxFailedAttempts() {
        return this.MaxFailedAttempts;
    }

    private FiniteDuration accountLockoutDuration() {
        return this.accountLockoutDuration;
    }

    private boolean accountLockoutEnabled() {
        return this.accountLockoutEnabled;
    }

    @Transactional(value="xlrRepositoryTransactionManager", propagation=Propagation.REQUIRED, isolation=Isolation.READ_COMMITTED, noRollbackFor={NotFoundException.class})
    public UserProfile recordFailedAttempt(String username) {
        Option lastFailedAt;
        Date now = new Date();
        Date unlockThresholdTime = new Date(now.getTime() - this.accountLockoutDuration().toMillis());
        UserProfile userProfile = this.userProfileService.findByUsernameForUpdate(username);
        if (userProfile == null) {
            this.logger().error((Function0 & Serializable)() -> "[AccountLockProtectionService][" + username + "]: User profile for [" + username + "] not found. Cannot record failed login attempt.");
            return null;
        }
        int currentCount = userProfile.getLastFailedLoginAttemptCount();
        boolean currentLocked = userProfile.isAccountLocked();
        if (this.shouldSkipUpdate(currentLocked, (Option<Date>)(lastFailedAt = Option$.MODULE$.apply((Object)userProfile.getLastFailedLoginAt())), unlockThresholdTime)) {
            long minutesRemaining = this.getMinutesRemaining((Date)lastFailedAt.get(), now);
            AutoLockThresholdNotReachedEvent event = new AutoLockThresholdNotReachedEvent(currentCount, minutesRemaining);
            event.user_$eq(username);
            this.eventBus.publish((XLReleaseEvent)event);
            return userProfile;
        }
        boolean shouldReset = lastFailedAt.isEmpty() || lastFailedAt.exists((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.before(unlockThresholdTime)));
        this.logger().debug((Function0 & Serializable)() -> "[AccountLockProtectionService][" + username + "] - Calculating new state: currentCount=" + currentCount + ", currentLocked=" + currentLocked + ", shouldReset=" + shouldReset);
        Tuple2<Object, Object> tuple2 = this.calculateNewState(currentCount, currentLocked, shouldReset, this.MaxFailedAttempts(), username);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        int newCount = tuple2._1$mcI$sp();
        boolean newLocked = tuple2._2$mcZ$sp();
        Tuple2.mcIZ.sp sp2 = new Tuple2.mcIZ.sp(newCount, newLocked);
        int newCount2 = sp2._1$mcI$sp();
        boolean newLocked2 = sp2._2$mcZ$sp();
        int rowsUpdated = this.userProfileService.updateFailedLoginAttempt(username, newCount2, Predef$.MODULE$.boolean2Boolean(newLocked2), now, Predef$.MODULE$.boolean2Boolean(true));
        if (rowsUpdated > 0) {
            userProfile.setLastFailedLoginAttemptCount(newCount2);
            userProfile.setAccountLocked(newLocked2);
            userProfile.setLastFailedLoginAt(now);
            this.logStateChanges(username, currentCount, currentLocked, newCount2, newLocked2);
        } else {
            this.logger().error((Function0 & Serializable)() -> "[AccountLockProtectionService][" + username + "]: Failed to update failed login attempt for user [" + username + "]. No rows affected.");
        }
        return userProfile;
    }

    private Tuple2<Object, Object> calculateNewState(int currentCount, boolean currentLocked, boolean shouldReset, int maxFailedAttempt, String username) {
        boolean shouldLock;
        if (currentLocked && shouldReset) {
            this.logger().debug((Function0 & Serializable)() -> "[AccountLockProtectionService][" + username + "]: Account locked and threshold passed. Unlocking and resetting counter to 1.");
            return new Tuple2.mcIZ.sp(1, false);
        }
        if (currentLocked) {
            this.logger().debug((Function0 & Serializable)() -> "[AccountLockProtectionService][" + username + "]: Account locked, threshold not passed. Freezing counter at " + currentCount + ".");
            return new Tuple2.mcIZ.sp(currentCount, true);
        }
        int incrementedCount = currentCount + 1;
        boolean bl = shouldLock = incrementedCount >= maxFailedAttempt;
        if (shouldLock) {
            this.logger().debug((Function0 & Serializable)() -> "[AccountLockProtectionService][" + username + "]: Incrementing counter to " + incrementedCount + " and locking account.");
            return new Tuple2.mcIZ.sp(incrementedCount, true);
        }
        this.logger().debug((Function0 & Serializable)() -> "[AccountLockProtectionService][" + username + "]: Incrementing counter to " + incrementedCount + ". Account remains unlocked.");
        return new Tuple2.mcIZ.sp(incrementedCount, false);
    }

    private void logStateChanges(String username, int currentCount, boolean currentLocked, int newCount, boolean newLocked) {
        if (!currentLocked && newLocked) {
            long autoUnlockMinutes = this.accountLockoutDuration().toMinutes();
            this.logger().warn((Function0 & Serializable)() -> "[AccountLockProtectionService][" + username + "]: Account locked for user [" + username + "] after reaching " + newCount + " failed attempts. Auto-unlock in " + autoUnlockMinutes + " minutes.");
            AccountLockedEvent event = new AccountLockedEvent(newCount, autoUnlockMinutes);
            event.user_$eq(username);
            this.eventBus.publish((XLReleaseEvent)event);
        }
        if (currentLocked && !newLocked) {
            AccountUnlockAndFailedAttemptsResetEvent event = new AccountUnlockAndFailedAttemptsResetEvent(newCount);
            event.user_$eq(username);
            this.eventBus.publish((XLReleaseEvent)event);
        }
        if (!currentLocked && !newLocked && newCount > currentCount) {
            FailedLoginAttemptEvent event = new FailedLoginAttemptEvent(newCount, this.MaxFailedAttempts());
            event.user_$eq(username);
            this.eventBus.publish((XLReleaseEvent)event);
            return;
        }
    }

    private boolean shouldSkipUpdate(boolean currentLocked, Option<Date> lastFailedAt, Date unlockThresholdTime) {
        return currentLocked && lastFailedAt.exists((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)x$3.after(unlockThresholdTime)));
    }

    private long getMinutesRemaining(Date lastFailedAt, Date now) {
        Date unlockTime = new Date(lastFailedAt.getTime() + this.accountLockoutDuration().toMillis());
        long remainingMillis = unlockTime.getTime() - now.getTime();
        return Math.max(0L, remainingMillis / 60000L);
    }

    public boolean isAccountLocked(String username) {
        Date unlockThresholdTime;
        if (!this.accountLockoutEnabled()) {
            this.logger().debug((Function0 & Serializable)() -> "[AccountLockProtectionService][" + username + "] - Account lockout not enabled.");
            return false;
        }
        UserProfile userProfile = this.userProfileService.findByUsername(username);
        if (userProfile == null || !userProfile.isAccountLocked()) {
            this.logger().debug((Function0 & Serializable)() -> "[AccountLockProtectionService][" + username + "] - User not found or Account not locked.");
            return false;
        }
        Date now = new Date();
        Option lastFailedAt = Option$.MODULE$.apply((Object)userProfile.getLastFailedLoginAt());
        boolean isLockedAndThresholdNotReached = lastFailedAt.exists(arg_0 -> AccountLockProtectionService.$anonfun$isAccountLocked$3$adapted(unlockThresholdTime = new Date(now.getTime() - this.accountLockoutDuration().toMillis()), arg_0));
        if (isLockedAndThresholdNotReached) {
            this.logger().debug((Function0 & Serializable)() -> "[AccountLockProtectionService][" + username + "] - Account locked: " + userProfile.isAccountLocked() + ", threshold NOT reached: " + isLockedAndThresholdNotReached + ". Returning true.");
        } else {
            this.logger().debug((Function0 & Serializable)() -> "[AccountLockProtectionService][" + username + "] - Account locked: " + userProfile.isAccountLocked() + ", threshold reached: " + !isLockedAndThresholdNotReached + ". Returning false.");
        }
        return isLockedAndThresholdNotReached;
    }

    public void resetFailedAttemptsAfterSuccessLogin(String username) {
        if (this.accountLockoutEnabled() && this.usersRepository.userExistsInRepository(username)) {
            UserProfile userProfile = this.userProfileService.findByUsername(username);
            if (userProfile != null) {
                if (userProfile.isAccountLocked() || userProfile.getLastFailedLoginAttemptCount() > 0) {
                    int rowsUpdated = this.userProfileService.updateFailedLoginAttempt(username, 0, Predef$.MODULE$.boolean2Boolean(false), null, Predef$.MODULE$.boolean2Boolean(true));
                    if (rowsUpdated > 0) {
                        this.logger().debug((Function0 & Serializable)() -> "[AccountLockProtectionService][" + username + "] - Reset failed login attempts and unlock account if locked.");
                        AccountUnlockedAfterSuccessfulLoginEvent event = new AccountUnlockedAfterSuccessfulLoginEvent();
                        event.user_$eq(username);
                        this.eventBus.publish((XLReleaseEvent)event);
                        return;
                    }
                    this.logger().error((Function0 & Serializable)() -> "[AccountLockProtectionService][" + username + "]: Failed to reset failed login attempts. No rows affected.");
                    return;
                }
                this.logger().debug((Function0 & Serializable)() -> "[AccountLockProtectionService][" + username + "] - No reset needed. Account not locked and failed attempts is 0.");
                return;
            }
            this.logger().debug((Function0 & Serializable)() -> "[AccountLockProtectionService][$username] - No reset needed. User profile not found.");
            return;
        }
    }

    public void unlockAccount(UserProfile userProfile) {
        if (userProfile != null) {
            String username = userProfile.getCanonicalId();
            if (userProfile.isAccountLocked()) {
                int rowsUpdated = this.userProfileService.updateFailedLoginAttempt(username, 0, Predef$.MODULE$.boolean2Boolean(false), null, Predef$.MODULE$.boolean2Boolean(true));
                if (rowsUpdated > 0) {
                    this.logger().debug((Function0 & Serializable)() -> "[AccountLockProtectionService][" + username + "] - Admin Action - Manually unlocked account and reset failed login attempts.");
                    AccountUnlockEvent event = new AccountUnlockEvent();
                    event.user_$eq(username);
                    this.eventBus.publish((XLReleaseEvent)event);
                    return;
                }
                this.logger().error((Function0 & Serializable)() -> "[AccountLockProtectionService][" + username + "]: Failed to unlock account. No rows affected.");
                return;
            }
            this.logger().debug((Function0 & Serializable)() -> "[AccountLockProtectionService][" + username + "] - No unlock needed. Account is not locked.");
            return;
        }
        this.logger().debug((Function0 & Serializable)() -> "[AccountLockProtectionService][$username] - No unlock needed. User profile not found.");
    }

    public void publishAuthenticationFailureLockEvent(String username) {
        AuthenticationFailureLockEvent event = new AuthenticationFailureLockEvent();
        event.user_$eq(username);
        this.eventBus.publish((XLReleaseEvent)event);
    }

    public AccountLockProtectionService(XlrConfig xlrConfig, UserProfileService userProfileService, EventBus eventBus, Users usersRepository) {
        this.userProfileService = userProfileService;
        this.eventBus = eventBus;
        this.usersRepository = usersRepository;
        Logging.$init$((Logging)this);
        this.MaxFailedAttempts = xlrConfig.maxFailedLoginAttempt();
        this.accountLockoutDuration = xlrConfig.accountLockoutDuration();
        this.accountLockoutEnabled = xlrConfig.isAccountLockoutEnabled();
    }

    public static final /* synthetic */ Object $anonfun$isAccountLocked$3$adapted(Date unlockThresholdTime$3, Date x$4) {
        return BoxesRunTime.boxToBoolean((boolean)x$4.after(unlockThresholdTime$3));
    }
}

