/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.events;

import com.xebialabs.xlrelease.events.EventListener;
import com.xebialabs.xlrelease.events.XLReleaseEventBus;
import com.xebialabs.xlrelease.events.XLReleaseEventListener;
import jakarta.annotation.Resource;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Component;

@Component
public class EventListenerRegister {
    private static final Logger logger = LoggerFactory.getLogger(EventListenerRegister.class);
    @Resource(name="eventFactoryBean")
    private List<XLReleaseEventListener> eventListeners;
    @Autowired
    private XLReleaseEventBus eventBus;
    @Autowired
    @EventListener
    private List<Object> annotatedEventListeners;
    @Autowired
    private ApplicationContext ctx;

    public void registerEventListeners() {
        logger.debug("Registering event listeners.");
        this.annotatedEventListeners.forEach(listener -> {
            logger.debug("Registering event listener {}", (Object)listener.getClass().getCanonicalName());
            this.eventBus.register(listener);
        });
        this.eventListeners.forEach(listener -> {
            this.ctx.getAutowireCapableBeanFactory().autowireBean(listener);
            logger.debug("Registering event listener {}", (Object)listener.getClass().getCanonicalName());
            this.eventBus.register(listener);
        });
    }
}

