/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.scheduler.strategies;

import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.deployit.plugin.api.validation.Range;
import com.xebialabs.xlrelease.features.settings.JobSchedulerStrategySettings;
import com.xebialabs.xlrelease.scheduler.Job;
import com.xebialabs.xlrelease.scheduler.strategies.BackpressuredWaitJobSchedulerStrategy$;
import scala.concurrent.duration.FiniteDuration;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;
import scala.reflect.ScalaSignature;
import scala.util.Either;

@Metadata(label="Blocking backpressure", description="Original blocking backpressure strategy that blocks job execution until release system start responding fast enough")
@ScalaSignature(bytes="\u0006\u0005\u0005}g\u0001\u0002\u000e\u001c\u0001\u0019BQa\f\u0001\u0005\u0002AB\u0011b\r\u0001A\u0002\u0003\u0007I\u0011\u0001\u001b\t\u0013m\u0002\u0001\u0019!a\u0001\n\u0003a\u0004\"\u0003\"\u0001\u0001\u0004\u0005\t\u0015)\u00036\u0011\u0015Y\b\u0001\"\u0001}\u0011\u0015q\b\u0001\"\u0001\u0000\u0011)\t)\u0001\u0001a\u0001\u0002\u0004%\t\u0001\u000e\u0005\f\u0003\u000f\u0001\u0001\u0019!a\u0001\n\u0003\tI\u0001\u0003\u0006\u0002\u000e\u0001\u0001\r\u0011!Q!\nUBa!a\t\u0001\t\u0003a\bbBA\u0014\u0001\u0011\u0005\u0011\u0011\u0006\u0005\u000b\u0003_\u0001\u0001\u0019!a\u0001\n\u0003!\u0004bCA\u0019\u0001\u0001\u0007\t\u0019!C\u0001\u0003gA!\"a\u000e\u0001\u0001\u0004\u0005\t\u0015)\u00036\u0011\u0019\tI\u0005\u0001C\u0001y\"9\u0011Q\n\u0001\u0005\u0002\u0005=\u0003BCA+\u0001\u0001\u0007\t\u0019!C\u0001i!Y\u0011q\u000b\u0001A\u0002\u0003\u0007I\u0011AA-\u0011)\ti\u0006\u0001a\u0001\u0002\u0003\u0006K!\u000e\u0005\u0007\u0003g\u0002A\u0011\u0001?\t\u000f\u0005]\u0004\u0001\"\u0001\u0002z!9\u0011q\u0010\u0001\u0005B\u0005\u0005\u0005bBA\\\u0001\u0011\u0005\u0011\u0011\u0018\u0005\b\u0003\u0017\u0004A\u0011AA]\u0011\u001d\ti\r\u0001C\u0001\u0003s\u0013QFQ1dWB\u0014Xm]:ve\u0016$w+Y5u\u0015>\u00147k\u00195fIVdWM]*ue\u0006$XmZ=TKR$\u0018N\\4t\u0015\taR$\u0001\u0006tiJ\fG/Z4jKNT!AH\u0010\u0002\u0013M\u001c\u0007.\u001a3vY\u0016\u0014(B\u0001\u0011\"\u0003%AHN]3mK\u0006\u001cXM\u0003\u0002#G\u0005I\u00010\u001a2jC2\f'm\u001d\u0006\u0002I\u0005\u00191m\\7\u0004\u0001M\u0011\u0001a\n\t\u0003Q5j\u0011!\u000b\u0006\u0003U-\n\u0001b]3ui&twm\u001d\u0006\u0003Y}\t\u0001BZ3biV\u0014Xm]\u0005\u0003]%\u0012ADS8c'\u000eDW\rZ;mKJ\u001cFO]1uK\u001eL8+\u001a;uS:<7/\u0001\u0004=S:LGO\u0010\u000b\u0002cA\u0011!\u0007A\u0007\u00027\u0005\u0019\"/Z:q_:\u001cX\r\u00165sKNDw\u000e\u001c3NgV\tQ\u0007\u0005\u00027s5\tqGC\u00019\u0003\u0015\u00198-\u00197b\u0013\tQtGA\u0002J]R\fqC]3ta>t7/\u001a+ie\u0016\u001c\bn\u001c7e\u001bN|F%Z9\u0015\u0005u\u0002\u0005C\u0001\u001c?\u0013\tytG\u0001\u0003V]&$\bbB!\u0004\u0003\u0003\u0005\r!N\u0001\u0004q\u0012\n\u0014\u0001\u0006:fgB|gn]3UQJ,7\u000f[8mI6\u001b\b\u0005\u000b\u0002\u0005\tB\u0011Q\tS\u0007\u0002\r*\u0011qiN\u0001\u0006E\u0016\fgn]\u0005\u0003\u0013\u001a\u0013ABQ3b]B\u0013x\u000e]3sifDc\u0002B&bE\u0012,w\r\u001b6l[:|gN\u000b\u0002M1B\u0011QJV\u0007\u0002\u001d*\u0011q\nU\u0001\u0004k\u0012l'BA)S\u0003\r\t\u0007/\u001b\u0006\u0003'R\u000ba\u0001\u001d7vO&t'BA+\"\u0003!!W\r\u001d7ps&$\u0018BA,O\u0005!\u0001&o\u001c9feRL8&A-\u0011\u0005i{V\"A.\u000b\u0005qk\u0016\u0001B7fi\u0006T!AX\u001c\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0002a7\n)a-[3mI\u0006)A.\u00192fY\u0006\n1-\u0001\nSKN\u0004xN\\:fAQD'/Z:i_2$\u0017a\u00033fg\u000e\u0014\u0018\u000e\u001d;j_:\f\u0013AZ\u0001#%\u0016\u001c\bo\u001c8tK\u0002\"\bN]3tQ>dG\rI5oA5LG\u000e\\5tK\u000e|g\u000eZ:\u0002\u0019\u0011,g-Y;miZ\u000bG.^3\"\u0003%\f1!\r\u00191\u0003!\u0019\u0017\r^3h_JL\u0018%\u00017\u0002\u000b%t\u0007/\u001e;\u0002\u0017%\u001cHK]1og&,g\u000e^\r\u0002\u0003\u00051\u0001.\u001b3eK:Dc\u0001B9xqfT\bC\u0001:v\u001b\u0005\u0019(B\u0001;Q\u0003)1\u0018\r\\5eCRLwN\\\u0005\u0003mN\u0014QAU1oO\u0016\fq!\\5oS6,X.H\u0001e\u0003\u001di\u0017\r_5nk6l\"a\n\t\u0002-\u001d,GOU3ta>t7/\u001a+ie\u0016\u001c\bn\u001c7e\u001bN$\u0012!\u000e\u0015\u0003\u000b\u0011\u000bac]3u%\u0016\u001c\bo\u001c8tKRC'/Z:i_2$Wj\u001d\u000b\u0004{\u0005\u0005\u0001bB!\u0007\u0003\u0003\u0005\r!\u000e\u0015\u0003\r\u0011\u000bqb\u001d7fKB$UO]1uS>tWj]\u0001\u0014g2,W\r\u001d#ve\u0006$\u0018n\u001c8Ng~#S-\u001d\u000b\u0004{\u0005-\u0001bB!\t\u0003\u0003\u0005\r!N\u0001\u0011g2,W\r\u001d#ve\u0006$\u0018n\u001c8Ng\u0002B#!\u0003#)#%Y\u0015-a\u0005e\u0003/9\u00171\u00046l[:|g.\t\u0002\u0002\u0016\u0005q1\u000b\\3fa\u0002\"WO]1uS>t\u0017EAA\r\u0003Y\u001aF.Z3qA\u0011,(/\u0019;j_:\u0004\u0013N\u001c\u0011nS2d\u0017n]3d_:$7\u000fI5gAQD'/Z:i_2$\u0007%[:!e\u0016\f7\r[3eC\t\ti\"\u0001\u00032aA\u0002\u0004fB\u0005ro\u0006\u0005\u0012P_\u000f\u0003\u0003Q\u0010!cZ3u'2,W\r\u001d#ve\u0006$\u0018n\u001c8Ng\"\u0012!\u0002R\u0001\u0013g\u0016$8\u000b\\3fa\u0012+(/\u0019;j_:l5\u000fF\u0002>\u0003WAq!Q\u0006\u0002\u0002\u0003\u0007Q\u0007\u000b\u0002\f\t\u00061\"/Z:q_:\u001cX\r\u00165sKNDw\u000e\u001c3SCRLw.\u0001\u000esKN\u0004xN\\:f)\"\u0014Xm\u001d5pY\u0012\u0014\u0016\r^5p?\u0012*\u0017\u000fF\u0002>\u0003kAq!Q\u0007\u0002\u0002\u0003\u0007Q'A\fsKN\u0004xN\\:f)\"\u0014Xm\u001d5pY\u0012\u0014\u0016\r^5pA!\u0012a\u0002\u0012\u0015\u0012\u001d-\u000b\u0017Q\b3\u0002>\u001d\f\tE[6n]>t\u0017EAA \u0003a\u0011Vm\u001d9p]N,\u0007\u0005\u001e5sKNDw\u000e\u001c3!e\u0006$\u0018n\\\u0011\u0003\u0003\u0007\n!a\r\u0019)\u000f9\tx/a\u0012zqv\t!\"A\rhKR\u0014Vm\u001d9p]N,G\u000b\u001b:fg\"|G\u000e\u001a*bi&|\u0007FA\bE\u0003e\u0019X\r\u001e*fgB|gn]3UQJ,7\u000f[8mIJ\u000bG/[8\u0015\u0007u\n\t\u0006C\u0004B!\u0005\u0005\t\u0019A\u001b)\u0005A!\u0015AE<be:Lgn\u001a+ie\u0016\u001c\bn\u001c7e\u001bN\fac^1s]&tw\r\u00165sKNDw\u000e\u001c3Ng~#S-\u001d\u000b\u0004{\u0005m\u0003bB!\u0013\u0003\u0003\u0005\r!N\u0001\u0014o\u0006\u0014h.\u001b8h)\"\u0014Xm\u001d5pY\u0012l5\u000f\t\u0015\u0003'\u0011C\u0013cE&b\u0003G\"\u0017qM4\u0002l)\\WN\\8oC\t\t)'A\tXCJt\u0017N\\4!i\"\u0014Xm\u001d5pY\u0012\f#!!\u001b\u0002C]\u000b'O\\5oO\u0002\"\bN]3tQ>dG\rI5oA5LG\u000e\\5tK\u000e|g\u000eZ:\"\u0005\u00055\u0014!\u0002\u001c1aA\u0002\u0004fB\nrojL\u0018\u0011O\u000f\u0004\tM\u0005\u001f!F4fi^\u000b'O\\5oORC'/Z:i_2$Wj\u001d\u0015\u0003)\u0011\u000bQc]3u/\u0006\u0014h.\u001b8h)\"\u0014Xm\u001d5pY\u0012l5\u000fF\u0002>\u0003wBq!Q\u000b\u0002\u0002\u0003\u0007Q\u0007\u000b\u0002\u0016\t\u0006A1o\u00195fIVdW\r\u0006\u0003\u0002\u0004\u0006-\u0006\u0003BAC\u0003KsA!a\"\u0002\":!\u0011\u0011RAP\u001d\u0011\tY)!(\u000f\t\u00055\u00151\u0014\b\u0005\u0003\u001f\u000bIJ\u0004\u0003\u0002\u0012\u0006]UBAAJ\u0015\r\t)*J\u0001\u0007yI|w\u000e\u001e \n\u0003\u0011J!AI\u0012\n\u0005\u0001\n\u0013B\u0001\u0010 \u0013\taR$C\u0002\u0002$n\tACS8c'\u000eDW\rZ;mKJ\u001cFO]1uK\u001eL\u0018\u0002BAT\u0003S\u0013abU2iK\u0012,H.\u001a*fgVdGOC\u0002\u0002$nAq!!,\u0017\u0001\u0004\ty+A\u0002k_\n\u0004B!!-\u000246\tQ$C\u0002\u00026v\u00111AS8c\u0003E\u0011Xm\u001d9p]N,G\u000b\u001b:fg\"|G\u000eZ\u000b\u0003\u0003w\u0003B!!0\u0002H6\u0011\u0011q\u0018\u0006\u0005\u0003\u0003\f\u0019-\u0001\u0005ekJ\fG/[8o\u0015\r\t)mN\u0001\u000bG>t7-\u001e:sK:$\u0018\u0002BAe\u0003\u007f\u0013aBR5oSR,G)\u001e:bi&|g.A\u0007tY\u0016,\u0007\u000fR;sCRLwN\\\u0001\u0011o\u0006\u0014h.\u001b8h)\"\u0014Xm\u001d5pY\u0012D\u0013\u0002AAiC\u0006]G-a7\u0011\u00075\u000b\u0019.C\u0002\u0002V:\u0013\u0001\"T3uC\u0012\fG/Y\u0011\u0003\u00033\fQC\u00117pG.Lgn\u001a\u0011cC\u000e\\\u0007O]3tgV\u0014X-\t\u0002\u0002^\u0006\u0019xJ]5hS:\fG\u000e\t2m_\u000e\\\u0017N\\4!E\u0006\u001c7\u000e\u001d:fgN,(/\u001a\u0011tiJ\fG/Z4zAQD\u0017\r\u001e\u0011cY>\u001c7n\u001d\u0011k_\n\u0004S\r_3dkRLwN\u001c\u0011v]RLG\u000e\t:fY\u0016\f7/\u001a\u0011tsN$X-\u001c\u0011ti\u0006\u0014H\u000f\t:fgB|g\u000eZ5oO\u00022\u0017m\u001d;!K:|Wo\u001a5")
public class BackpressuredWaitJobSchedulerStrategySettings
extends JobSchedulerStrategySettings {
    @Property(label="Response threshold", description="Response threshold in milliseconds", defaultValue="100", category="input", isTransient=true, hidden=true)
    @Range(minimum=100, maximum=10000)
    private int responseThresholdMs;
    @Property(label="Sleep duration", description="Sleep duration in milliseconds if threshold is reached", defaultValue="1000", category="input", isTransient=true, hidden=true)
    @Range(minimum=500, maximum=10000)
    private int sleepDurationMs;
    @Property(label="Response threshold ratio", description="Response threshold ratio", defaultValue="30", category="input", isTransient=true, hidden=true)
    @Range(minimum=10, maximum=100)
    private int responseThresholdRatio;
    @Property(label="Warning threshold", description="Warning threshold in milliseconds", defaultValue="60000", category="input", isTransient=true, hidden=true)
    @Range(minimum=10000, maximum=300000)
    private int warningThresholdMs;

    public int responseThresholdMs() {
        return this.responseThresholdMs;
    }

    public void responseThresholdMs_$eq(int x$1) {
        this.responseThresholdMs = x$1;
    }

    public int sleepDurationMs() {
        return this.sleepDurationMs;
    }

    public void sleepDurationMs_$eq(int x$1) {
        this.sleepDurationMs = x$1;
    }

    public int responseThresholdRatio() {
        return this.responseThresholdRatio;
    }

    public void responseThresholdRatio_$eq(int x$1) {
        this.responseThresholdRatio = x$1;
    }

    public int warningThresholdMs() {
        return this.warningThresholdMs;
    }

    public void warningThresholdMs_$eq(int x$1) {
        this.warningThresholdMs = x$1;
    }

    @Override
    public Either<Job, Job> schedule(Job job) {
        return BackpressuredWaitJobSchedulerStrategy$.MODULE$.schedule(this, job);
    }

    public FiniteDuration responseThreshold() {
        return new package.DurationInt(package$.MODULE$.DurationInt(this.responseThresholdMs())).millis();
    }

    public FiniteDuration sleepDuration() {
        return new package.DurationInt(package$.MODULE$.DurationInt(this.sleepDurationMs())).millis();
    }

    public FiniteDuration warningThreshold() {
        return new package.DurationInt(package$.MODULE$.DurationInt(this.warningThresholdMs())).millis();
    }

    public int getResponseThresholdMs() {
        return this.responseThresholdMs();
    }

    public int getResponseThresholdRatio() {
        return this.responseThresholdRatio();
    }

    public int getSleepDurationMs() {
        return this.sleepDurationMs();
    }

    public int getWarningThresholdMs() {
        return this.warningThresholdMs();
    }

    public void setResponseThresholdMs(int x$1) {
        this.responseThresholdMs_$eq(x$1);
    }

    public void setResponseThresholdRatio(int x$1) {
        this.responseThresholdRatio_$eq(x$1);
    }

    public void setSleepDurationMs(int x$1) {
        this.sleepDurationMs_$eq(x$1);
    }

    public void setWarningThresholdMs(int x$1) {
        this.warningThresholdMs_$eq(x$1);
    }
}

