package com.xebialabs.xlrelease.validation

import com.fasterxml.jackson.databind.annotation.JsonSerialize

object FolderOperationReferenceCategory extends Enumeration {
  val RELEASE_CATEGORY: Value = Value("Release")
  val RELEASE_GROUP_CATEGORY: Value = Value("ReleaseGroup")
  val TEMPLATE_CATEGORY: Value = Value("Template")
  val TRIGGER_CATEGORY: Value = Value("Trigger")
  val CONFIGURATION_CATEGORY: Value = Value("Configuration")
}

case class FolderOperationValidationError(id: String,
                                          title: String,
                                          @JsonSerialize(using = classOf[FolderOperationReferenceCategorySerializer])
                                          category: FolderOperationReferenceCategory.Value,
                                          message: String)

case class FolderValidationErrors(message: String, errors: List[FolderOperationValidationError])
