/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.scheduler.service;

import com.xebialabs.xlrelease.actors.ActorSystemHolder;
import com.xebialabs.xlrelease.actors.ReleaseActorService;
import com.xebialabs.xlrelease.actors.cluster.XlrCluster$;
import com.xebialabs.xlrelease.actors.cluster.XlrCluster$ClusterMemberOps$;
import com.xebialabs.xlrelease.config.XlrConfig$;
import com.xebialabs.xlrelease.scheduler.JobQueue;
import com.xebialabs.xlrelease.scheduler.JobRecoveryLogic;
import com.xebialabs.xlrelease.scheduler.JobRow;
import com.xebialabs.xlrelease.scheduler.JobStatus;
import com.xebialabs.xlrelease.scheduler.NodeId;
import com.xebialabs.xlrelease.scheduler.TaskJob;
import com.xebialabs.xlrelease.scheduler.filters.JobFilters;
import com.xebialabs.xlrelease.scheduler.service.JobService;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Arrays;
import org.apache.pekko.actor.Address;
import org.apache.pekko.actor.Address$;
import org.slf4j.Marker;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import scala.Function0;
import scala.Function1;
import scala.Option$;
import scala.collection.Set;
import scala.collection.SortedSetOps;
import scala.collection.immutable.List;
import scala.collection.immutable.SortedSet;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@Service
@ScalaSignature(bytes="\u0006\u0005\t4A\u0001D\u0007\u00011!A1\u0005\u0001BC\u0002\u0013\u0005A\u0005\u0003\u0005)\u0001\t\u0005\t\u0015!\u0003&\u0011!I\u0003A!b\u0001\n\u0003Q\u0003\u0002C\u0018\u0001\u0005\u0003\u0005\u000b\u0011B\u0016\t\u0011A\u0002!Q1A\u0005\u0002EB\u0001\u0002\u000f\u0001\u0003\u0002\u0003\u0006IA\r\u0005\ts\u0001\u0011)\u0019!C\u0001u!Aa\b\u0001B\u0001B\u0003%1\bC\u0003@\u0001\u0011\u0005\u0001\tC\u0003V\u0001\u0011\u0005a\u000bC\u0003[\u0001\u0011\u0005aKA\tK_\n\u001cE.Z1okB\u001cVM\u001d<jG\u0016T!AD\b\u0002\u000fM,'O^5dK*\u0011\u0001#E\u0001\ng\u000eDW\rZ;mKJT!AE\n\u0002\u0013ad'/\u001a7fCN,'B\u0001\u000b\u0016\u0003%AXMY5bY\u0006\u00147OC\u0001\u0017\u0003\r\u0019w.\\\u0002\u0001'\r\u0001\u0011d\b\t\u00035ui\u0011a\u0007\u0006\u00029\u0005)1oY1mC&\u0011ad\u0007\u0002\u0007\u0003:L(+\u001a4\u0011\u0005\u0001\nS\"A\b\n\u0005\tz!\u0001\u0005&pEJ+7m\u001c<fefdunZ5d\u0003!QwNY)vKV,W#A\u0013\u0011\u0005\u00012\u0013BA\u0014\u0010\u0005!QuNY)vKV,\u0017!\u00036pEF+X-^3!\u0003)QwNY*feZL7-Z\u000b\u0002WA\u0011A&L\u0007\u0002\u001b%\u0011a&\u0004\u0002\u000b\u0015>\u00147+\u001a:wS\u000e,\u0017a\u00036pEN+'O^5dK\u0002\n\u0011#Y2u_J\u001c\u0016p\u001d;f[\"{G\u000eZ3s+\u0005\u0011\u0004CA\u001a7\u001b\u0005!$BA\u001b\u0012\u0003\u0019\t7\r^8sg&\u0011q\u0007\u000e\u0002\u0012\u0003\u000e$xN]*zgR,W\u000eS8mI\u0016\u0014\u0018AE1di>\u00148+_:uK6Du\u000e\u001c3fe\u0002\n1C]3mK\u0006\u001cX-Q2u_J\u001cVM\u001d<jG\u0016,\u0012a\u000f\t\u0003gqJ!!\u0010\u001b\u0003'I+G.Z1tK\u0006\u001bGo\u001c:TKJ4\u0018nY3\u0002)I,G.Z1tK\u0006\u001bGo\u001c:TKJ4\u0018nY3!\u0003\u0019a\u0014N\\5u}Q)\u0011IQ\"E\u000bB\u0011A\u0006\u0001\u0005\u0006G%\u0001\r!\n\u0005\u0006S%\u0001\ra\u000b\u0005\u0006a%\u0001\rA\r\u0005\u0006s%\u0001\ra\u000f\u0015\u0003\u0013\u001d\u0003\"\u0001S*\u000e\u0003%S!AS&\u0002\u0015\u0005tgn\u001c;bi&|gN\u0003\u0002M\u001b\u00069a-Y2u_JL(B\u0001(P\u0003\u0015\u0011W-\u00198t\u0015\t\u0001\u0016+A\btaJLgn\u001a4sC6,wo\u001c:l\u0015\u0005\u0011\u0016aA8sO&\u0011A+\u0013\u0002\n\u0003V$xn^5sK\u0012\fA\u0003Z3uK\u000e$\u0018IY1oI>tW\r\u001a+bg.\u001cH#A,\u0011\u0005iA\u0016BA-\u001c\u0005\u0011)f.\u001b;\u0002/\u0011,G/Z2u'R\fG.\u001a*fg\u0016\u0014h/\u001a3K_\n\u001c\bF\u0001\u0001]!\ti\u0006-D\u0001_\u0015\tyv*\u0001\u0006ti\u0016\u0014Xm\u001c;za\u0016L!!\u00190\u0003\u000fM+'O^5dK\u0002")
public class JobCleanupService
implements JobRecoveryLogic {
    private final JobQueue jobQueue;
    private final JobService jobService;
    private final ActorSystemHolder actorSystemHolder;
    private final ReleaseActorService releaseActorService;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    @Override
    public void recoverAllJobs() {
        JobRecoveryLogic.recoverAllJobs$(this);
    }

    @Override
    public void recoverJobs(String nodeId) {
        JobRecoveryLogic.recoverJobs$(this, nodeId);
    }

    @Override
    public String nodeId() {
        return NodeId.nodeId$(this);
    }

    @Override
    public String convertAddressToNodeId(Address address) {
        return NodeId.convertAddressToNodeId$(this, address);
    }

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        JobCleanupService jobCleanupService = this;
        synchronized (jobCleanupService) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        if (!this.bitmap$trans$0) {
            return this.grizzled$slf4j$Logging$$_logger$lzycompute();
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    @Override
    public JobQueue jobQueue() {
        return this.jobQueue;
    }

    @Override
    public JobService jobService() {
        return this.jobService;
    }

    @Override
    public ActorSystemHolder actorSystemHolder() {
        return this.actorSystemHolder;
    }

    @Override
    public ReleaseActorService releaseActorService() {
        return this.releaseActorService;
    }

    public void detectAbandonedTasks() {
        scala.collection.immutable.Set taskNodeIds = (scala.collection.immutable.Set)this.jobService().findDistinctNodeIds().filterNot((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)JobCleanupService.$anonfun$detectAbandonedTasks$1(x$1)));
        this.logger().debug((Function0 & Serializable)() -> "distinct nodeIds of tasks: " + taskNodeIds.mkString(", "));
        SortedSet aliveNodeIds = (SortedSet)((SortedSetOps)this.actorSystemHolder().cluster().state().members().filter((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)XlrCluster$ClusterMemberOps$.MODULE$.isAlive$extension(XlrCluster$.MODULE$.ClusterMemberOps(x$2))))).map((Function1 & Serializable)x$3 -> x$3.address(), Address$.MODULE$.addressOrdering()).map((Function1 & Serializable)address -> this.convertAddressToNodeId((Address)address), (Ordering)Ordering.String$.MODULE$);
        this.logger().debug((Function0 & Serializable)() -> "alive nodeIds: " + aliveNodeIds.mkString(", "));
        scala.collection.immutable.Set deadNodes = (scala.collection.immutable.Set)taskNodeIds.diff((Set)aliveNodeIds);
        deadNodes.foreach((Function1 & Serializable)nodeId -> {
            JobCleanupService.$anonfun$detectAbandonedTasks$7(this, nodeId);
            return BoxedUnit.UNIT;
        });
    }

    public void detectStaleReservedJobs() {
        JobFilters jobFilters = new JobFilters();
        jobFilters.status_$eq(Arrays.asList((Object[])new String[]{JobStatus.RESERVED.name()}));
        List<TaskJob<?>> taskJobs = this.jobService().findAllTaskJobs(jobFilters, Pageable.unpaged(), true);
        long staleReservedJobDetectionPeriodInSeconds = XlrConfig$.MODULE$.getInstance().timeouts().staleReservedJobDetectionPeriod().toSeconds();
        Instant earliestAllowedJobInstant = Instant.now().minus(staleReservedJobDetectionPeriodInSeconds, ChronoUnit.SECONDS);
        taskJobs.filter((Function1 & Serializable)j -> BoxesRunTime.boxToBoolean((boolean)JobCleanupService.$anonfun$detectStaleReservedJobs$1(earliestAllowedJobInstant, j))).foreach((Function1 & Serializable)lateJob -> {
            JobCleanupService.$anonfun$detectStaleReservedJobs$2(this, lateJob);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ boolean $anonfun$detectAbandonedTasks$1(String x$1) {
        return x$1 == null;
    }

    public static final /* synthetic */ void $anonfun$detectAbandonedTasks$7(JobCleanupService $this, String nodeId) {
        $this.logger().warn((Function0 & Serializable)() -> "Discovered dead node " + nodeId + ", failing/recovering tasks assigned to that node");
        $this.recoverJobs(nodeId);
    }

    public static final /* synthetic */ boolean $anonfun$detectStaleReservedJobs$1(Instant earliestAllowedJobInstant$1, TaskJob j) {
        return j.reservationTime() == null || j.reservationTime().isBefore(earliestAllowedJobInstant$1);
    }

    public static final /* synthetic */ void $anonfun$detectStaleReservedJobs$4(JobCleanupService $this, TaskJob updatedJob) {
        $this.jobQueue().submitExisting(updatedJob);
    }

    public static final /* synthetic */ void $anonfun$detectStaleReservedJobs$3(JobCleanupService $this, TaskJob lateJob$1, JobRow updatedJobRow) {
        lateJob$1.version_$eq(updatedJobRow.version());
        lateJob$1.node_$eq(updatedJobRow.node());
        lateJob$1.status_$eq(updatedJobRow.status());
        Option$.MODULE$.apply((Object)lateJob$1).foreach((Function1 & Serializable)updatedJob -> {
            JobCleanupService.$anonfun$detectStaleReservedJobs$4($this, updatedJob);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$detectStaleReservedJobs$2(JobCleanupService $this, TaskJob lateJob) {
        $this.jobService().updateJobNodeAndStatus(lateJob, null, JobStatus.QUEUED).foreach((Function1 & Serializable)updatedJobRow -> {
            JobCleanupService.$anonfun$detectStaleReservedJobs$3($this, lateJob, updatedJobRow);
            return BoxedUnit.UNIT;
        });
    }

    @Autowired
    public JobCleanupService(JobQueue jobQueue, JobService jobService, ActorSystemHolder actorSystemHolder, ReleaseActorService releaseActorService) {
        this.jobQueue = jobQueue;
        this.jobService = jobService;
        this.actorSystemHolder = actorSystemHolder;
        this.releaseActorService = releaseActorService;
        Logging.$init$((Logging)this);
        NodeId.$init$(this);
        JobRecoveryLogic.$init$(this);
    }
}

