package com.xebialabs.xlrelease.api.internal

class DecoratorCache[T](val key: String = null, val cache: java.util.Map[String, Object] = null) {
  def computeIfAbsent(fn: () => T): T = {
    if (cache == null) {
      fn()
    } else {
      cache.computeIfAbsent(key, (_) => fn().asInstanceOf[Object]).asInstanceOf[T]
    }
  }
}
