package com.xebialabs.xlrelease.actors.initializer

import com.xebialabs.xlrelease.config.XlrConfig
import com.xebialabs.xlrelease.service.{XlrServiceLifecycle, XlrServiceLifecycleOrder}
import org.springframework.stereotype.Component

import scala.jdk.CollectionConverters._

@Component
class SubscriptionInitializersLifecycleManager(subscriptionInitializers: java.util.List[_ <: SubscriptionInitializer], xlrConfig: XlrConfig)
  extends XlrServiceLifecycle {

  override def getOrder: Int = XlrServiceLifecycleOrder.SUBSCRIPTION_INITIALIZERS

  override def doStart(): Unit = {
    if (xlrConfig.maintenanceModeEnabled) {
      logger.warn("[MAINTENANCE MODE] Webhook triggers - DISABLED")
    } else {
      subscriptionInitializers.asScala.sortBy(_.getOrder).foreach(subscriptionInitializer => {
        try {
          subscriptionInitializer.initialize()
        } catch {
          case e: Exception =>
            logger.error(s"Unable to initialize ${subscriptionInitializer.getClass.getName}", e)
            throw e
        }
      })
    }
  }

  override def doStop(): Unit = {
    //Nothing to stop
  }
}
