/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.api.v1;

import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.exception.NotFoundException;
import com.xebialabs.deployit.security.permission.Permission;
import com.xebialabs.xlrelease.actors.ReleaseActorService;
import com.xebialabs.xlrelease.api.v1.forms.CreateTeam;
import com.xebialabs.xlrelease.api.v1.views.TeamView;
import com.xebialabs.xlrelease.domain.Team;
import com.xebialabs.xlrelease.domain.events.TeamCreatedEvent;
import com.xebialabs.xlrelease.domain.events.TeamDeletedEvent;
import com.xebialabs.xlrelease.domain.events.TeamUpdatedEvent;
import com.xebialabs.xlrelease.domain.events.XLReleaseEvent;
import com.xebialabs.xlrelease.events.XLReleaseEventBus;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.security.PermissionChecker;
import com.xebialabs.xlrelease.service.CreateTeamOperation;
import com.xebialabs.xlrelease.service.TeamMembership;
import com.xebialabs.xlrelease.service.TeamService;
import com.xebialabs.xlrelease.service.TeamUpdateOperation;
import com.xebialabs.xlrelease.views.converters.TeamViewConverter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import scala.Option;
import scala.collection.immutable.Seq;
import scala.jdk.javaapi.CollectionConverters;

@Component
public class TeamFacade {
    private final PermissionChecker permissions;
    private final TeamService teamService;
    private final TeamViewConverter teamViewConverter;
    private final ReleaseActorService releaseActorService;
    private final XLReleaseEventBus eventBus;
    private static final List<String> SYSTEM_TEAMS = Arrays.asList("Folder Owner", "Release Admin", "Template Owner");

    @Autowired
    public TeamFacade(PermissionChecker permissions, TeamService teamService, TeamViewConverter teamViewConverter, ReleaseActorService releaseActorService, XLReleaseEventBus eventBus) {
        this.permissions = permissions;
        this.teamService = teamService;
        this.teamViewConverter = teamViewConverter;
        this.releaseActorService = releaseActorService;
        this.eventBus = eventBus;
    }

    public List<TeamView> getTeams(String containerId) {
        this.permissions.checkViewTeams(containerId);
        return this.teamService.getEffectivePublicTeamViews(containerId, this.teamViewConverter);
    }

    public List<TeamView> setTeams(String containerId, List<TeamView> teamsToUpdate) {
        Checks.checkNotNull(teamsToUpdate, (String)"No teams submitted for update.");
        List<Team> submittedTeams = teamsToUpdate.stream().map(this.teamViewConverter::toTeam).toList();
        this.permissions.checkEditTeamsAgainstExisting(containerId, submittedTeams);
        Set<String> unknownPermissions = this.findUnknownPermissions(teamsToUpdate);
        Checks.checkArgument((boolean)unknownPermissions.isEmpty(), (String)"Unknown permissions found: '%s'", (Object[])new Object[]{String.join((CharSequence)", ", unknownPermissions)});
        if (Ids.isReleaseId((String)containerId)) {
            this.releaseActorService.updateTeams(containerId, submittedTeams);
        } else {
            if (Ids.isInRootFolder((String)containerId) || !teamsToUpdate.isEmpty()) {
                this.checkSystemTeamsArePresent(teamsToUpdate);
            }
            this.teamService.saveTeamsToPlatform(containerId, submittedTeams);
        }
        return this.teamService.getPublicTeamViews(containerId);
    }

    public Set<String> findUnknownPermissions(List<TeamView> teamsToUpdate) {
        return this.extractUnknownPermissions(teamsToUpdate.stream().flatMap(team -> team.getPermissions().stream()).collect(Collectors.toSet()));
    }

    private void checkForUnknownPermissions(Set<String> permissions) {
        Set<String> unknown = this.extractUnknownPermissions(permissions);
        Checks.checkArgument((boolean)unknown.isEmpty(), (String)"Unknown permissions found: '%s'", (Object[])new Object[]{String.join((CharSequence)", ", unknown)});
    }

    private Set<String> extractUnknownPermissions(Set<String> permissions) {
        return permissions.stream().filter(p -> Permission.find((String)p) == null).collect(Collectors.toUnmodifiableSet());
    }

    private void checkSystemTeamsArePresent(List<TeamView> teamsToUpdate) {
        ArrayList<String> missingSystemTeams = new ArrayList<String>(SYSTEM_TEAMS);
        List<String> updateTeams = teamsToUpdate.stream().map(TeamView::getTeamName).toList();
        missingSystemTeams.removeAll(updateTeams);
        Checks.checkArgument((boolean)missingSystemTeams.isEmpty(), (String)"Cannot update teams with the following system teams missing: %s", (Object[])new Object[]{missingSystemTeams});
    }

    private boolean containerInheritsSecurity(String containerId) {
        String effectiveSecureId;
        String containerSecureId = this.teamService.securedCis().getSecuredCi(containerId).getSecurityUid();
        return !containerSecureId.equals(effectiveSecureId = this.teamService.securedCis().getEffectiveSecuredCi(containerId).getSecurityUid());
    }

    private void checkContainer(String containerId) {
        if (this.containerInheritsSecurity(containerId)) {
            throw new Checks.IncorrectArgumentException(String.format("Security in container %s is inherited", containerId), new Object[0]);
        }
    }

    public Team getTeam(String containerId, String teamId) {
        this.permissions.checkViewTeams(containerId);
        this.checkContainer(containerId);
        Option<Team> maybeId = this.teamService.securityRepository().findTeamById(containerId, teamId);
        if (maybeId.isDefined()) {
            return (Team)maybeId.get();
        }
        throw new NotFoundException(String.format("Team %s not found", teamId), new Object[0]);
    }

    public Team findTeam(String containerId, String teamName) {
        this.permissions.checkViewTeams(containerId);
        this.checkContainer(containerId);
        Option<Team> maybeId = this.teamService.securityRepository().findTeamByName(containerId, teamName);
        if (maybeId.isDefined()) {
            return (Team)maybeId.get();
        }
        throw new NotFoundException(String.format("Team %s not found", teamName), new Object[0]);
    }

    public String createTeam(String containerId, CreateTeam createTeam) {
        TeamMembership membership = new TeamMembership((scala.collection.immutable.Set<String>)CollectionConverters.asScala((List)createTeam.getPrincipals()).toSet(), (scala.collection.immutable.Set<String>)CollectionConverters.asScala((List)createTeam.getRoles()).toSet(), (scala.collection.immutable.Set<String>)CollectionConverters.asScala((List)createTeam.getPermissions()).toSet());
        CreateTeamOperation op = new CreateTeamOperation(containerId, createTeam.getName(), membership);
        this.permissions.checkEditTeams(containerId, (Seq<TeamUpdateOperation>)CollectionConverters.asScala(List.of(op)).toSeq());
        this.checkContainer(containerId);
        Set<String> createTeamPermissions = createTeam.getPermissions().stream().collect(Collectors.toUnmodifiableSet());
        this.checkForUnknownPermissions(createTeamPermissions);
        String teamId = this.teamService.securityRepository().createTeam(containerId, createTeam.getName(), (scala.collection.immutable.Set<String>)CollectionConverters.asScala((List)createTeam.getRoles()).toSet(), (scala.collection.immutable.Set<String>)CollectionConverters.asScala((List)createTeam.getPrincipals()).toSet(), (scala.collection.immutable.Set<String>)CollectionConverters.asScala(createTeamPermissions).toSet());
        Team team = this.teamService.securityRepository().getTeam(teamId);
        this.eventBus.publish((XLReleaseEvent)new TeamCreatedEvent(containerId, team));
        return teamId;
    }

    public void addPrincipalsToTeamById(String containerId, String teamId, List<String> principalNames) {
        this.checkContainer(containerId);
        Option<Team> original = this.teamService.securityRepository().findTeamById(containerId, teamId);
        if (!original.isDefined()) {
            throw new NotFoundException(String.format("Team %s not found", teamId), new Object[0]);
        }
        this.updateTeamAndFireEvents(containerId, (Team)original.get(), () -> this.permissions.checkEditTeamMembers(containerId, (Team)original.get()), () -> this.teamService.securityRepository().addPrincipalsToTeam(teamId, (scala.collection.immutable.Set<String>)CollectionConverters.asScala((List)principalNames).toSet()));
    }

    public void addPrincipalsToTeamByName(String containerId, String teamName, List<String> principalNames) {
        this.checkContainer(containerId);
        Option<Team> original = this.teamService.securityRepository().findTeamByName(containerId, teamName);
        if (!original.isDefined()) {
            throw new NotFoundException(String.format("Team %s not found", teamName), new Object[0]);
        }
        this.updateTeamAndFireEvents(containerId, (Team)original.get(), () -> this.permissions.checkEditTeamMembers(containerId, (Team)original.get()), () -> this.teamService.securityRepository().addPrincipalsToTeam(((Team)original.get()).getId(), (scala.collection.immutable.Set<String>)CollectionConverters.asScala((List)principalNames).toSet()));
    }

    public void removePrincipalsFromTeamById(String containerId, String teamId, List<String> principalNames) {
        this.checkContainer(containerId);
        Option<Team> original = this.teamService.securityRepository().findTeamById(containerId, teamId);
        if (!original.isDefined()) {
            throw new NotFoundException(String.format("Team %s not found", teamId), new Object[0]);
        }
        this.updateTeamAndFireEvents(containerId, (Team)original.get(), () -> this.permissions.checkEditTeamMembers(containerId, (Team)original.get()), () -> this.teamService.securityRepository().removePrincipalsFromTeam(teamId, (scala.collection.immutable.Set<String>)CollectionConverters.asScala((List)principalNames).toSet()));
    }

    public void removePrincipalsFromTeamByName(String containerId, String teamName, List<String> principalNames) {
        this.checkContainer(containerId);
        Option<Team> original = this.teamService.securityRepository().findTeamByName(containerId, teamName);
        if (!original.isDefined()) {
            throw new NotFoundException(String.format("Team %s not found", teamName), new Object[0]);
        }
        this.updateTeamAndFireEvents(containerId, (Team)original.get(), () -> this.permissions.checkEditTeamMembers(containerId, (Team)original.get()), () -> this.teamService.securityRepository().removePrincipalsFromTeam(((Team)original.get()).getId(), (scala.collection.immutable.Set<String>)CollectionConverters.asScala((List)principalNames).toSet()));
    }

    public void addRoleNamesToTeamById(String containerId, String teamId, List<String> roleNames) {
        this.checkContainer(containerId);
        Option<Team> original = this.teamService.securityRepository().findTeamById(containerId, teamId);
        if (!original.isDefined()) {
            throw new NotFoundException(String.format("Team %s not found", teamId), new Object[0]);
        }
        this.updateTeamAndFireEvents(containerId, (Team)original.get(), () -> this.permissions.checkEditTeamMembers(containerId, (Team)original.get()), () -> this.teamService.securityRepository().addRolesByNameToTeam(teamId, (scala.collection.immutable.Set<String>)CollectionConverters.asScala((List)roleNames).toSet()));
    }

    public void addRoleNamesToTeamByName(String containerId, String teamName, List<String> roleNames) {
        this.checkContainer(containerId);
        Option<Team> original = this.teamService.securityRepository().findTeamByName(containerId, teamName);
        if (!original.isDefined()) {
            throw new NotFoundException(String.format("Team %s not found", teamName), new Object[0]);
        }
        this.updateTeamAndFireEvents(containerId, (Team)original.get(), () -> this.permissions.checkEditTeamMembers(containerId, (Team)original.get()), () -> this.teamService.securityRepository().addRolesByNameToTeam(((Team)original.get()).getId(), (scala.collection.immutable.Set<String>)CollectionConverters.asScala((List)roleNames).toSet()));
    }

    public void removeRoleNamesFromTeamById(String containerId, String teamId, List<String> roleNames) {
        this.checkContainer(containerId);
        Option<Team> original = this.teamService.securityRepository().findTeamById(containerId, teamId);
        if (!original.isDefined()) {
            throw new NotFoundException(String.format("Team %s not found", teamId), new Object[0]);
        }
        this.updateTeamAndFireEvents(containerId, (Team)original.get(), () -> this.permissions.checkEditTeamMembers(containerId, (Team)original.get()), () -> this.teamService.securityRepository().removeRolesByNameFromTeam(teamId, (scala.collection.immutable.Set<String>)CollectionConverters.asScala((List)roleNames).toSet()));
    }

    public void removeRoleNamesFromTeamByName(String containerId, String teamName, List<String> roleNames) {
        this.checkContainer(containerId);
        Option<Team> original = this.teamService.securityRepository().findTeamByName(containerId, teamName);
        if (!original.isDefined()) {
            throw new NotFoundException(String.format("Team %s not found", teamName), new Object[0]);
        }
        this.updateTeamAndFireEvents(containerId, (Team)original.get(), () -> this.permissions.checkEditTeamMembers(containerId, (Team)original.get()), () -> this.teamService.securityRepository().removeRolesByNameFromTeam(((Team)original.get()).getId(), (scala.collection.immutable.Set<String>)CollectionConverters.asScala((List)roleNames).toSet()));
    }

    public void addPermissionsToTeamById(String containerId, String teamId, List<String> permissionsToAdd) {
        this.checkContainer(containerId);
        Set<String> p = permissionsToAdd.stream().collect(Collectors.toUnmodifiableSet());
        this.checkForUnknownPermissions(p);
        Set removed = Collections.emptySet();
        Option<Team> original = this.teamService.securityRepository().findTeamById(containerId, teamId);
        if (!original.isDefined()) {
            throw new NotFoundException(String.format("Team %s not found", teamId), new Object[0]);
        }
        this.updateTeamAndFireEvents(containerId, (Team)original.get(), () -> this.permissions.checkEditTeamPermissions(containerId, (Seq<String>)CollectionConverters.asScala((Set)p).toSeq(), (Seq<String>)CollectionConverters.asScala((Set)removed).toSeq()), () -> this.teamService.securityRepository().addPermissionsToTeam(teamId, (scala.collection.immutable.Set<String>)CollectionConverters.asScala((Set)p).toSet()));
    }

    public void addPermissionsToTeamByName(String containerId, String teamName, List<String> permissionsToAdd) {
        this.checkContainer(containerId);
        Set<String> p = permissionsToAdd.stream().collect(Collectors.toUnmodifiableSet());
        this.checkForUnknownPermissions(p);
        Set removed = Collections.emptySet();
        Option<Team> original = this.teamService.securityRepository().findTeamByName(containerId, teamName);
        if (!original.isDefined()) {
            throw new NotFoundException(String.format("Team %s not found", teamName), new Object[0]);
        }
        this.updateTeamAndFireEvents(containerId, (Team)original.get(), () -> this.permissions.checkEditTeamPermissions(containerId, (Seq<String>)CollectionConverters.asScala((Set)p).toSeq(), (Seq<String>)CollectionConverters.asScala((Set)removed).toSeq()), () -> this.teamService.securityRepository().addPermissionsToTeam(((Team)original.get()).getId(), (scala.collection.immutable.Set<String>)CollectionConverters.asScala((Set)p).toSet()));
    }

    public void removePermissionsFromTeamById(String containerId, String teamId, List<String> permissionsToRemove) {
        this.checkContainer(containerId);
        Set added = Collections.emptySet();
        Option<Team> original = this.teamService.securityRepository().findTeamById(containerId, teamId);
        if (!original.isDefined()) {
            throw new NotFoundException(String.format("Team %s not found", teamId), new Object[0]);
        }
        this.updateTeamAndFireEvents(containerId, (Team)original.get(), () -> this.permissions.checkEditTeamPermissions(containerId, (Seq<String>)CollectionConverters.asScala((Set)added).toSeq(), (Seq<String>)CollectionConverters.asScala((List)permissionsToRemove).toSeq()), () -> this.teamService.securityRepository().removePermissionsFromTeam(teamId, (scala.collection.immutable.Set<String>)CollectionConverters.asScala((List)permissionsToRemove).toSet()));
    }

    public void removePermissionsFromTeamByName(String containerId, String teamName, List<String> permissionsToRemove) {
        this.checkContainer(containerId);
        Set added = Collections.emptySet();
        Option<Team> original = this.teamService.securityRepository().findTeamByName(containerId, teamName);
        if (!original.isDefined()) {
            throw new NotFoundException(String.format("Team %s not found", teamName), new Object[0]);
        }
        this.updateTeamAndFireEvents(containerId, (Team)original.get(), () -> this.permissions.checkEditTeamPermissions(containerId, (Seq<String>)CollectionConverters.asScala((Set)added).toSeq(), (Seq<String>)CollectionConverters.asScala((List)permissionsToRemove).toSeq()), () -> this.teamService.securityRepository().removePermissionsFromTeam(((Team)original.get()).getId(), (scala.collection.immutable.Set<String>)CollectionConverters.asScala((List)permissionsToRemove).toSet()));
    }

    public void deleteTeamById(String containerId, String teamId) {
        this.checkContainer(containerId);
        Option<Team> original = this.teamService.securityRepository().findTeamById(containerId, teamId);
        if (!original.isDefined()) {
            throw new NotFoundException(String.format("Team %s not found", teamId), new Object[0]);
        }
        this.permissions.checkDeleteTeam(containerId, (Team)original.get());
        this.teamService.securityRepository().deleteTeam(teamId);
        this.eventBus.publish((XLReleaseEvent)new TeamDeletedEvent(containerId, (Team)original.get()));
    }

    public void deleteTeamByName(String containerId, String teamName) {
        this.checkContainer(containerId);
        Option<Team> original = this.teamService.securityRepository().findTeamByName(containerId, teamName);
        if (!original.isDefined()) {
            throw new NotFoundException(String.format("Team %s not found", teamName), new Object[0]);
        }
        this.permissions.checkDeleteTeam(containerId, (Team)original.get());
        this.teamService.securityRepository().deleteTeam(((Team)original.get()).getId());
        this.eventBus.publish((XLReleaseEvent)new TeamDeletedEvent(containerId, (Team)original.get()));
    }

    private void updateTeamAndFireEvents(String containerId, Team originalTeam, Runnable permissionCheck, Runnable action) {
        permissionCheck.run();
        action.run();
        Team updatedTeam = this.teamService.securityRepository().getTeam(originalTeam.getId());
        if (originalTeam != updatedTeam) {
            this.eventBus.publish((XLReleaseEvent)new TeamUpdatedEvent(containerId, originalTeam, updatedTeam));
        }
    }
}

