/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.script.el;

import com.xebialabs.xlrelease.domain.PreconditionType;
import com.xebialabs.xlrelease.domain.Task;
import com.xebialabs.xlrelease.script.ExceptionPreconditionResult;
import com.xebialabs.xlrelease.script.InvalidPreconditionResult;
import com.xebialabs.xlrelease.script.PreconditionResult;
import com.xebialabs.xlrelease.script.PreconditionService;
import com.xebialabs.xlrelease.script.ValidPreconditionResult;
import com.xebialabs.xlrelease.script.el.EvaluationContextBuilder;
import com.xebialabs.xlrelease.security.authentication.AuthenticationService;
import com.xebialabs.xlrelease.service.CommentService;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import org.slf4j.Marker;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.ExpressionParser;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.util.StringUtils;
import scala.Function0;
import scala.None$;
import scala.Option;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005A4A!\u0003\u0006\u0001+!A!\u0006\u0001B\u0001B\u0003%1\u0006\u0003\u00054\u0001\t\u0005\t\u0015!\u00035\u0011!Q\u0004A!A!\u0002\u0013Y\u0004\u0002C#\u0001\u0005\u0003\u0005\u000b\u0011\u0002$\t\u000b)\u0003A\u0011A&\t\u000bE\u0003A\u0011\t*\t\u000b\u0001\u0004A\u0011I1\t\u000b5\u0004A\u0011\u00028\u0003+\u0015c\u0007K]3d_:$\u0017\u000e^5p]N+'O^5dK*\u00111\u0002D\u0001\u0003K2T!!\u0004\b\u0002\rM\u001c'/\u001b9u\u0015\ty\u0001#A\u0005yYJ,G.Z1tK*\u0011\u0011CE\u0001\nq\u0016\u0014\u0017.\u00197bENT\u0011aE\u0001\u0004G>l7\u0001A\n\u0005\u0001Yq\"\u0005\u0005\u0002\u001895\t\u0001D\u0003\u0002\u001a5\u0005!A.\u00198h\u0015\u0005Y\u0012\u0001\u00026bm\u0006L!!\b\r\u0003\r=\u0013'.Z2u!\ty\u0002%D\u0001\r\u0013\t\tCBA\nQe\u0016\u001cwN\u001c3ji&|gnU3sm&\u001cW\r\u0005\u0002$Q5\tAE\u0003\u0002&M\u0005)1\u000f\u001c45U*\tq%\u0001\u0005he&T(\u0010\\3e\u0013\tICEA\u0004M_\u001e<\u0017N\\4\u0002+\u0005,H\u000f[3oi&\u001c\u0017\r^5p]N+'O^5dKB\u0011A&M\u0007\u0002[)\u0011afL\u0001\u000fCV$\b.\u001a8uS\u000e\fG/[8o\u0015\t\u0001d\"\u0001\u0005tK\u000e,(/\u001b;z\u0013\t\u0011TFA\u000bBkRDWM\u001c;jG\u0006$\u0018n\u001c8TKJ4\u0018nY3\u0002\u001d\r|W.\\3oiN+'O^5dKB\u0011Q\u0007O\u0007\u0002m)\u0011qGD\u0001\bg\u0016\u0014h/[2f\u0013\tIdG\u0001\bD_6lWM\u001c;TKJ4\u0018nY3\u0002\rA\f'o]3s!\ta4)D\u0001>\u0015\tqt(\u0001\u0006fqB\u0014Xm]:j_:T!\u0001Q!\u0002\u001fM\u0004(/\u001b8hMJ\fW.Z<pe.T\u0011AQ\u0001\u0004_J<\u0017B\u0001#>\u0005A)\u0005\u0010\u001d:fgNLwN\u001c)beN,'/\u0001\rfm\u0006dW/\u0019;j_:\u001cuN\u001c;fqR\u0014U/\u001b7eKJ\u0004\"a\u0012%\u000e\u0003)I!!\u0013\u0006\u00031\u00153\u0018\r\\;bi&|gnQ8oi\u0016DHOQ;jY\u0012,'/\u0001\u0004=S:LGO\u0010\u000b\u0006\u00196su\n\u0015\t\u0003\u000f\u0002AQAK\u0003A\u0002-BQaM\u0003A\u0002QBQAO\u0003A\u0002mBQ!R\u0003A\u0002\u0019\u000ba!\u001a8hS:,G#A*\u0011\u0005QkfBA+\\!\t1\u0016,D\u0001X\u0015\tAF#\u0001\u0004=e>|GO\u0010\u0006\u00025\u0006)1oY1mC&\u0011A,W\u0001\u0007!J,G-\u001a4\n\u0005y{&AB*ue&twM\u0003\u0002]3\u0006\u0019R\r_3dkR,\u0007K]3d_:$\u0017\u000e^5p]R\u0011!-\u001a\t\u0003?\rL!\u0001\u001a\u0007\u0003%A\u0013XmY8oI&$\u0018n\u001c8SKN,H\u000e\u001e\u0005\u0006M\u001e\u0001\raZ\u0001\u0005i\u0006\u001c8\u000e\u0005\u0002iW6\t\u0011N\u0003\u0002k\u001d\u00051Am\\7bS:L!\u0001\\5\u0003\tQ\u000b7o[\u0001\u0016Kb,7-\u001e;f\u000b2\u0004&/Z2p]\u0012LG/[8o)\t\u0011w\u000eC\u0003g\u0011\u0001\u0007q\r")
public class ElPreconditionService
implements PreconditionService,
Logging {
    private final AuthenticationService authenticationService;
    private final CommentService commentService;
    private final ExpressionParser parser;
    private final EvaluationContextBuilder evaluationContextBuilder;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        ElPreconditionService elPreconditionService = this;
        synchronized (elPreconditionService) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        if (!this.bitmap$trans$0) {
            return this.grizzled$slf4j$Logging$$_logger$lzycompute();
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    @Override
    public String engine() {
        return PreconditionType.EL.engine;
    }

    @Override
    public PreconditionResult executePrecondition(Task task) {
        PreconditionResult preconditionResult;
        try {
            this.authenticationService.loginScriptUser(task);
            preconditionResult = this.executeElPrecondition(task);
        }
        finally {
            this.authenticationService.logoutScriptUser();
        }
        PreconditionResult result = preconditionResult;
        Object object = StringUtils.hasText((String)result.executionLog()) ? this.commentService.appendComment(task, null, result.executionLog()) : BoxedUnit.UNIT;
        return result;
    }

    private PreconditionResult executeElPrecondition(Task task) {
        PreconditionResult preconditionResult;
        Authentication currentAuthentication = SecurityContextHolder.getContext().getAuthentication();
        try {
            Expression expression = this.parser.parseExpression(task.getPrecondition());
            EvaluationContext context = this.evaluationContextBuilder.buildPreconditionContext(task);
            boolean expressionResult = BoxesRunTime.unboxToBoolean((Object)expression.getValue(context, Boolean.TYPE));
            preconditionResult = expressionResult ? new ValidPreconditionResult(task.getId(), task.getExecutionId(), "Precondition is valid (returned True)", (Option<String>)None$.MODULE$, currentAuthentication) : new InvalidPreconditionResult(task.getId(), task.getExecutionId(), "Precondition is invalid (returned a value that is not True)", (Option<String>)None$.MODULE$, currentAuthentication);
        }
        catch (Exception exception) {
            this.logger().debug((Function0 & Serializable)() -> "Precondition evaluation failed.", (Function0 & Serializable)() -> exception);
            preconditionResult = new ExceptionPreconditionResult(task.getId(), task.getExecutionId(), "Precondition evaluation failed. Failure: " + exception.getMessage(), (Option<String>)None$.MODULE$, currentAuthentication);
        }
        PreconditionResult result = preconditionResult;
        return result;
    }

    public ElPreconditionService(AuthenticationService authenticationService, CommentService commentService, ExpressionParser parser, EvaluationContextBuilder evaluationContextBuilder) {
        this.authenticationService = authenticationService;
        this.commentService = commentService;
        this.parser = parser;
        this.evaluationContextBuilder = evaluationContextBuilder;
        Logging.$init$((Logging)this);
    }
}

