/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.service;

import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.exception.NotFoundException;
import com.xebialabs.deployit.repository.ItemConflictException;
import com.xebialabs.xlrelease.api.v1.forms.TenantLinkRequest;
import com.xebialabs.xlrelease.api.v1.forms.TenantResourceLinkOperation;
import com.xebialabs.xlrelease.domain.Tenant;
import com.xebialabs.xlrelease.domain.events.FolderTenantLinkEvent;
import com.xebialabs.xlrelease.domain.events.TenantCreatedEvent;
import com.xebialabs.xlrelease.domain.events.TenantDeletedEvent;
import com.xebialabs.xlrelease.domain.events.TenantUpdatedEvent;
import com.xebialabs.xlrelease.domain.events.UserProfileTenantLinkEvent;
import com.xebialabs.xlrelease.domain.events.XLReleaseEvent;
import com.xebialabs.xlrelease.domain.status.TenantStatus;
import com.xebialabs.xlrelease.events.EventBus;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.repository.TenantRepository;
import java.io.Serializable;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Tuple2;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@Service
@ScalaSignature(bytes="\u0006\u0005\u0005\u001db\u0001\u0002\u0007\u000e\u0001YA\u0001\"\b\u0001\u0003\u0002\u0003\u0006IA\b\u0005\tI\u0001\u0011\t\u0011)A\u0005K!)1\u0006\u0001C\u0001Y!)\u0011\u0007\u0001C\u0001e!)Q\t\u0001C\u0001\r\")\u0011\u000b\u0001C\u0001%\")Q\u000b\u0001C\u0001-\")\u0011\r\u0001C\u0001E\")\u0001\u000e\u0001C\u0001S\")1\u000e\u0001C\u0001Y\"9\u00111\u0001\u0001\u0005\n\u0005\u0015!!\u0004+f]\u0006tGoU3sm&\u001cWM\u0003\u0002\u000f\u001f\u000591/\u001a:wS\u000e,'B\u0001\t\u0012\u0003%AHN]3mK\u0006\u001cXM\u0003\u0002\u0013'\u0005I\u00010\u001a2jC2\f'm\u001d\u0006\u0002)\u0005\u00191m\\7\u0004\u0001M\u0011\u0001a\u0006\t\u00031mi\u0011!\u0007\u0006\u00025\u0005)1oY1mC&\u0011A$\u0007\u0002\u0007\u0003:L(+\u001a4\u0002!Q,g.\u00198u%\u0016\u0004xn]5u_JL\bCA\u0010#\u001b\u0005\u0001#BA\u0011\u0010\u0003)\u0011X\r]8tSR|'/_\u0005\u0003G\u0001\u0012\u0001\u0003V3oC:$(+\u001a9pg&$xN]=\u0002\u0011\u00154XM\u001c;CkN\u0004\"AJ\u0015\u000e\u0003\u001dR!\u0001K\b\u0002\r\u00154XM\u001c;t\u0013\tQsE\u0001\u0005Fm\u0016tGOQ;t\u0003\u0019a\u0014N\\5u}Q\u0019Qf\f\u0019\u0011\u00059\u0002Q\"A\u0007\t\u000bu\u0019\u0001\u0019\u0001\u0010\t\u000b\u0011\u001a\u0001\u0019A\u0013\u0002\u001b\u001d,G/\u00117m)\u0016t\u0017M\u001c;t)\u0005\u0019\u0004c\u0001\u001b=\u007f9\u0011QG\u000f\b\u0003mej\u0011a\u000e\u0006\u0003qU\ta\u0001\u0010:p_Rt\u0014\"\u0001\u000e\n\u0005mJ\u0012a\u00029bG.\fw-Z\u0005\u0003{y\u0012A\u0001T5ti*\u00111(\u0007\t\u0003\u0001\u000ek\u0011!\u0011\u0006\u0003\u0005>\ta\u0001Z8nC&t\u0017B\u0001#B\u0005\u0019!VM\\1oi\u0006qa-\u001b8e)\u0016t\u0017M\u001c;Cs&#GCA H\u0011\u0015AU\u00011\u0001J\u0003!!XM\\1oi&#\u0007C\u0001&O\u001d\tYE\n\u0005\u000273%\u0011Q*G\u0001\u0007!J,G-\u001a4\n\u0005=\u0003&AB*ue&twM\u0003\u0002N3\u0005\u0001b-\u001b8e)\u0016t\u0017M\u001c;Cs:\u000bW.\u001a\u000b\u0003\u007fMCQ\u0001\u0016\u0004A\u0002%\u000bAA\\1nK\u0006a1M]3bi\u0016$VM\\1oiR\u0019qhV-\t\u000ba;\u0001\u0019A%\u0002\u0015Q,g.\u00198u\u001d\u0006lW\rC\u0003[\u000f\u0001\u00071,\u0001\u0007uK:\fg\u000e^*uCR,8\u000f\u0005\u0002]?6\tQL\u0003\u0002_\u0003\u000611\u000f^1ukNL!\u0001Y/\u0003\u0019Q+g.\u00198u'R\fG/^:\u0002\u0019U\u0004H-\u0019;f)\u0016t\u0017M\u001c;\u0015\u0005\r4\u0007C\u0001\re\u0013\t)\u0017D\u0001\u0003V]&$\b\"B4\t\u0001\u0004y\u0014A\u0002;f]\u0006tG/\u0001\u0007eK2,G/\u001a+f]\u0006tG\u000f\u0006\u0002dU\")\u0001*\u0003a\u0001\u0013\u0006aA.\u001b8l%\u0016\u001cx.\u001e:dKR\u00191-\u001c8\t\u000b!S\u0001\u0019A%\t\u000b=T\u0001\u0019\u00019\u0002\u00191Lgn\u001b*fcV,7\u000f^:\u0011\u0007E4x/D\u0001s\u0015\t\u0019H/\u0001\u0003vi&d'\"A;\u0002\t)\fg/Y\u0005\u0003{I\u0004\"\u0001_@\u000e\u0003eT!A_>\u0002\u000b\u0019|'/\\:\u000b\u0005ql\u0018A\u0001<2\u0015\tqx\"A\u0002ba&L1!!\u0001z\u0005E!VM\\1oi2Kgn\u001b*fcV,7\u000f^\u0001\u0012G\",7m\u001b(b[\u0016L5/\u00168jcV,G#B2\u0002\b\u0005%\u0001\"\u0002+\f\u0001\u0004I\u0005B\u0002%\f\u0001\u0004\tY\u0001\u0005\u0003\u0019\u0003\u001bI\u0015bAA\b3\t1q\n\u001d;j_:D3\u0001AA\n!\u0011\t)\"a\t\u000e\u0005\u0005]!\u0002BA\r\u00037\t!b\u001d;fe\u0016|G/\u001f9f\u0015\u0011\ti\"a\b\u0002\u001fM\u0004(/\u001b8hMJ\fW.Z<pe.T!!!\t\u0002\u0007=\u0014x-\u0003\u0003\u0002&\u0005]!aB*feZL7-\u001a")
public class TenantService {
    private final TenantRepository tenantRepository;
    private final EventBus eventBus;

    public List<Tenant> getAllTenants() {
        return this.tenantRepository.findAll().toList();
    }

    public Tenant findTenantById(String tenantId) {
        Checks.checkArgument((boolean)StringUtils.hasText((String)tenantId), (String)"Tenant ID cannot be empty", (Object[])new Object[0]);
        return (Tenant)this.tenantRepository.findById(tenantId).getOrElse((Function0 & Serializable)() -> {
            throw new NotFoundException("No tenant found with ID '" + tenantId + "'", new Object[0]);
        });
    }

    public Tenant findTenantByName(String name) {
        Checks.checkArgument((boolean)StringUtils.hasText((String)name), (String)"Tenant name cannot be empty", (Object[])new Object[0]);
        return (Tenant)this.tenantRepository.findByName(name.toLowerCase().trim()).getOrElse((Function0 & Serializable)() -> {
            throw new NotFoundException("No tenant found with name '" + name + "'", new Object[0]);
        });
    }

    public Tenant createTenant(String tenantName, TenantStatus tenantStatus) {
        Checks.checkArgument((boolean)StringUtils.hasText((String)tenantName), (String)"Tenant name cannot be empty", (Object[])new Object[0]);
        Checks.checkArgument((tenantStatus != null ? 1 : 0) != 0, (String)"Tenant status cannot be null", (Object[])new Object[0]);
        String normalizedTenantName = tenantName.toLowerCase().trim();
        this.checkNameIsUnique(normalizedTenantName, (Option<String>)None$.MODULE$);
        Tenant createdTenant = this.tenantRepository.create(normalizedTenantName, tenantStatus);
        this.eventBus.publish((XLReleaseEvent)new TenantCreatedEvent(createdTenant));
        return createdTenant;
    }

    public void updateTenant(Tenant tenant) {
        Checks.checkArgument((tenant != null ? 1 : 0) != 0, (String)"Tenant cannot be null", (Object[])new Object[0]);
        Checks.checkArgument((boolean)StringUtils.hasText((String)tenant.tenantName()), (String)"Tenant name cannot be empty", (Object[])new Object[0]);
        Checks.checkArgument((tenant.tenantStatus() != null ? 1 : 0) != 0, (String)"Tenant status cannot be null", (Object[])new Object[0]);
        Tenant original = this.findTenantById(tenant.tenantId());
        this.checkNameIsUnique(tenant.tenantName().toLowerCase().trim(), (Option<String>)Option$.MODULE$.apply((Object)tenant.tenantId()));
        this.tenantRepository.update(tenant);
        this.eventBus.publish((XLReleaseEvent)new TenantUpdatedEvent(original, tenant));
    }

    public void deleteTenant(String tenantId) {
        Checks.checkArgument((boolean)StringUtils.hasText((String)tenantId), (String)"Tenant ID cannot be empty", (Object[])new Object[0]);
        Tenant tenant = this.findTenantById(tenantId);
        this.tenantRepository.delete(tenantId);
        this.eventBus.publish((XLReleaseEvent)new TenantDeletedEvent(tenant));
    }

    public void linkResource(String tenantId, java.util.List<TenantLinkRequest> linkRequests) {
        Checks.checkArgument((boolean)StringUtils.hasText((String)tenantId), (String)"Tenant ID cannot be empty", (Object[])new Object[0]);
        Checks.checkArgument((linkRequests != null ? 1 : 0) != 0, (String)"Link requests cannot be null", (Object[])new Object[0]);
        this.findTenantById(tenantId);
        CollectionConverters$.MODULE$.ListHasAsScala(linkRequests).asScala().toList().groupBy((Function1 & Serializable)x$1 -> x$1.getLinkOperation()).foreach((Function1 & Serializable)x0$1 -> {
            TenantService.$anonfun$linkResource$2(this, tenantId, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    private void checkNameIsUnique(String name, Option<String> tenantId) {
        this.tenantRepository.findByName(name).foreach((Function1 & Serializable)existingTenant -> {
            TenantService.$anonfun$checkNameIsUnique$1(tenantId, name, existingTenant);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ boolean $anonfun$linkResource$4(String str) {
        return StringUtils.hasText((String)str);
    }

    public static final /* synthetic */ boolean $anonfun$linkResource$5(String id) {
        return Ids.isFolderId((String)id);
    }

    public static final /* synthetic */ boolean $anonfun$linkResource$9(String str) {
        return StringUtils.hasText((String)str);
    }

    public static final /* synthetic */ void $anonfun$linkResource$2(TenantService $this, String tenantId$2, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            TenantResourceLinkOperation tenantResourceLinkOperation = (TenantResourceLinkOperation)tuple2._1();
            List folderRequests = (List)tuple2._2();
            if (TenantResourceLinkOperation.FOLDER.equals(tenantResourceLinkOperation)) {
                List folderIds = folderRequests.map((Function1 & Serializable)x$2 -> x$2.getTargetId()).filter((Function1 & Serializable)str -> BoxesRunTime.boxToBoolean((boolean)TenantService.$anonfun$linkResource$4(str))).filter((Function1 & Serializable)id -> BoxesRunTime.boxToBoolean((boolean)TenantService.$anonfun$linkResource$5(id))).map((Function1 & Serializable)id -> Ids.getName((String)id)).map((Function1 & Serializable)id -> Ids.normalizeId((String)id));
                if (folderIds.nonEmpty()) {
                    $this.tenantRepository.linkFoldersToTenant(tenantId$2, (List<String>)folderIds);
                    $this.eventBus.publish((XLReleaseEvent)new FolderTenantLinkEvent(tenantId$2, (Seq)folderIds));
                    return;
                }
                return;
            }
        }
        if (tuple2 != null) {
            TenantResourceLinkOperation tenantResourceLinkOperation = (TenantResourceLinkOperation)tuple2._1();
            List userProfileRequests = (List)tuple2._2();
            if (TenantResourceLinkOperation.USER_PROFILE.equals(tenantResourceLinkOperation)) {
                List userProfileIds = userProfileRequests.map((Function1 & Serializable)x$3 -> x$3.getTargetId()).filter((Function1 & Serializable)str -> BoxesRunTime.boxToBoolean((boolean)TenantService.$anonfun$linkResource$9(str))).map((Function1 & Serializable)x$4 -> x$4.toLowerCase());
                if (userProfileIds.nonEmpty()) {
                    $this.tenantRepository.linkUserProfilesToTenant(tenantId$2, (List<String>)userProfileIds);
                    $this.eventBus.publish((XLReleaseEvent)new UserProfileTenantLinkEvent(tenantId$2, (Seq)userProfileIds));
                    return;
                }
                return;
            }
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ void $anonfun$checkNameIsUnique$1(Option tenantId$3, String name$2, Tenant existingTenant) {
        if (!tenantId$3.contains((Object)existingTenant.tenantId())) {
            throw new ItemConflictException("Tenant with name '" + name$2 + "' already exists", new Object[0]);
        }
    }

    public TenantService(TenantRepository tenantRepository, EventBus eventBus) {
        this.tenantRepository = tenantRepository;
        this.eventBus = eventBus;
    }
}

