package com.xebialabs.xlrelease.views.converters;

import java.util.*;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.xlrelease.domain.Task;
import com.xebialabs.xlrelease.domain.tasks.TaskViewConverter;
import com.xebialabs.xlrelease.views.TaskFullView;

import static java.lang.String.format;
import static java.util.stream.Collectors.toList;

@Component
public class TasksViewConverter {

    private Map<Type, TaskViewConverter> taskViewConverters = new HashMap<>();

    @Autowired
    public void setTaskViewConverters(List<? extends TaskViewConverter> taskViewConverters) {
        taskViewConverters.forEach(converter -> this.taskViewConverters.put(converter.getTaskType(), converter));
    }

    public TaskFullView toFullView(Task task, List<Type> allowedTaskTypesForAuthenticatedUser) {
        //noinspection unchecked
        final TaskViewConverter taskViewConverter = getConverterFor(task.getType());
        return taskViewConverter.toFullView(task, allowedTaskTypesForAuthenticatedUser);
    }

    public List<TaskFullView> toFullView(Collection<? extends Task> tasks, List<Type> allowedTaskTypesForAuthenticatedUser) {
        return tasks.stream().map(t -> toFullView(t, allowedTaskTypesForAuthenticatedUser)).collect(toList());
    }

    public Task toTask(TaskFullView view) {
        return getConverterFor(Type.valueOf(view.getType())).toTask(view);
    }

    private TaskViewConverter getConverterFor(final Type taskType) {
        TaskViewConverter taskViewConverter = findConverterFor(taskType);
        if (null == taskViewConverter) {
            throw new IllegalStateException(format("TaskFullViewConverter is not defined for task '%s'", taskType));
        }
        return taskViewConverter;
    }

    private TaskViewConverter findConverterFor(Type taskType) {
        List<Type> typeHierarchy = new ArrayList<>();
        typeHierarchy.add(taskType);
        typeHierarchy.addAll(taskType.getDescriptor().getSuperClasses());

        Optional<TaskViewConverter> r = typeHierarchy.stream()
                .map(t -> taskViewConverters.get(t))
                .filter(Objects::nonNull)
                .findFirst();
        return r.orElse(null);
    }
}
