package com.xebialabs.xlrelease.db.sql.transaction

import org.springframework.beans.BeansException
import org.springframework.beans.factory.config.{BeanFactoryPostProcessor, ConfigurableListableBeanFactory}
import org.springframework.stereotype.Component
import org.springframework.transaction.interceptor.TransactionInterceptor

@Component
class XlrTransactionInterceptorPostProcessor extends BeanFactoryPostProcessor {
  @throws[BeansException]
  override def postProcessBeanFactory(factory: ConfigurableListableBeanFactory): Unit = {
    val names = factory.getBeanNamesForType(classOf[TransactionInterceptor])
    for (name <- names) {
      val bd = factory.getBeanDefinition(name)
      bd.setBeanClassName(classOf[XlrTransactionInterceptor].getName)
    }
  }
}
