package com.xebialabs.xlrelease.api.internal;

import com.xebialabs.xlrelease.utils.TenantContext$;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.core.Context;
import org.springframework.stereotype.Controller;

import java.io.IOException;

@Path("/docs")
@Controller
public class DocsResource {

    @GET
    @Path("/{version:[0-9]+\\.[0-9]+}/{path:.*}")
    public void redirectToDocs(@PathParam("version") String version,
                               @PathParam("path") String path,
                               @Context HttpServletRequest _request,
                               @Context HttpServletResponse response) throws IOException {
        response.setStatus(HttpServletResponse.SC_FOUND);
        if (TenantContext$.MODULE$.isSystemTenant()) {
            response.sendRedirect("https://docs.digital.ai/release/docs/" + version + "/" + path);
        } else {
            // if needed we can get the original host with request.getHeader("Referer") and replace it in the next line
            String saasDocs = "https://docs.digital.ai/release/docs/saas/" + path;
            response.sendRedirect(saasDocs);
        }

    }

}
