package com.xebialabs.xlrelease.repository

import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem
import com.xebialabs.xlrelease.domain.Release
import com.xebialabs.xlrelease.domain.variables.Variable

trait ReleaseVariableRepository {

  def create(variable: Variable, updatedRelease: Release): Variable

  def create(variables: Seq[Variable], updatedRelease: Release): Unit

  def update(original: Variable, updated: Variable, updatedRelease: Release): Unit

  def update(originalList: Seq[Variable], updatedList: Seq[Variable], updatedRelease: Release): Unit

  def delete(variableId: String, updatedRelease: Release): Unit

  def replace(updatedRelease: Release, updatedReleaseCis: Seq[ConfigurationItem]): Unit

  def exists(variableId: String): Boolean

  def findById(variableId: String): Variable

  def findByKey(key: String, releaseId: String): Variable

}
