package com.xebialabs.xlrelease.script;

import java.util.Map;
import java.util.function.Function;

import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.variables.Variable;

import static com.xebialabs.xlrelease.script.ScriptServiceHelper.extractFolderVariables;
import static com.xebialabs.xlrelease.script.ScriptServiceHelper.extractGlobalVariables;
import static com.xebialabs.xlrelease.script.ScriptServiceHelper.extractReleaseVariables;

public class VariablesHolderForScriptContext {
    private XlrScriptContext scriptContext;
    private final Release release;
    private final String folderId;
    private Map<String, Variable> previousReleaseVariables;
    private Map<String, Variable> previousFolderVariables;
    private Map<String, Variable> previousGlobalVariables;
    private Function<DefaultScriptService.VariablesUpdateHolder, DefaultScriptService.ScriptTaskResults> synchronizeCallback;

    public VariablesHolderForScriptContext(
            Release release,
            String folderId,
            Map<String, Variable> previousReleaseVariables,
            Map<String, Variable> previousFolderVariables,
            Map<String, Variable> previousGlobalVariables,
            Function<DefaultScriptService.VariablesUpdateHolder, DefaultScriptService.ScriptTaskResults> synchronizeCallback
    ) {
        this.release = release;
        this.folderId = folderId;
        this.previousReleaseVariables = previousReleaseVariables;
        this.previousFolderVariables = previousFolderVariables;
        this.previousGlobalVariables = previousGlobalVariables;
        this.synchronizeCallback = synchronizeCallback;
    }

    public Map<String, Variable> getPreviousReleaseVariables() {
        return previousReleaseVariables;
    }

    public Map<String, Variable> getPreviousFolderVariables() {
        return previousFolderVariables;
    }

    public Map<String, Variable> getPreviousGlobalVariables() {
        return previousGlobalVariables;
    }

    public VariablesHolderForScriptContext setPreviousReleaseVariables(Map<String, Variable> previousReleaseVariables) {
        this.previousReleaseVariables = previousReleaseVariables;
        return this;
    }

    public VariablesHolderForScriptContext setPreviousFolderVariables(Map<String, Variable> previousFolderVariables) {
        this.previousFolderVariables = previousFolderVariables;
        return this;
    }

    public VariablesHolderForScriptContext setPreviousGlobalVariables(Map<String, Variable> previousGlobalVariables) {
        this.previousGlobalVariables = previousGlobalVariables;
        return this;
    }

    public XlrScriptContext getScriptContext() {
        return scriptContext;
    }

    public VariablesHolderForScriptContext setScriptContext(XlrScriptContext scriptContext) {
        this.scriptContext = scriptContext;
        return this;
    }

    public DefaultScriptService.ScriptTaskResults createScriptTaskResults() {
        DefaultScriptService.VariablesUpdateHolder variablesUpdateHolder = new DefaultScriptService.VariablesUpdateHolder(
                extractReleaseVariables(this.getScriptContext()),
                extractGlobalVariables(this.getScriptContext()),
                extractFolderVariables(this.getScriptContext()),
                this.getPreviousReleaseVariables(),
                this.getPreviousGlobalVariables(),
                this.getPreviousFolderVariables());

        return synchronizeCallback.apply(variablesUpdateHolder);
    }

    public Release getRelease() {
        return release;
    }

    public String getFolderId() {
        return folderId;
    }
}
