package com.xebialabs.deployit.plumbing;

import java.io.IOException;
import jakarta.servlet.*;
import jakarta.servlet.http.HttpServletRequest;
import org.slf4j.MDC;

public class LogbackFilter implements Filter {

    private static final String REQUEST_KEY = "request";
    private static final String METHOD_KEY = "method";

    @Override
    public void init(FilterConfig filterConfig) throws ServletException {}

    @Override
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest servletRequest = (HttpServletRequest) request;
        String method = servletRequest.getMethod();
        String url = servletRequest.getRequestURI();

        MDC.put(METHOD_KEY, method);
        MDC.put(REQUEST_KEY, url);
        try {
            chain.doFilter(request, response);
        } finally {
            MDC.remove(REQUEST_KEY);
            MDC.remove(METHOD_KEY);
        }
    }

    @Override
    public void destroy() {}
}
