package com.xebialabs.xlrelease.service;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.xebialabs.deployit.exception.NotFoundException;
import com.xebialabs.xlrelease.repository.Ids;

import io.micrometer.core.annotation.Timed;

@Service
public class ReleaseTitleResolver {

    private static final Logger logger = LoggerFactory.getLogger(ReleaseTitleResolver.class);

    private ReleaseService releaseService;

    @Autowired
    public ReleaseTitleResolver(final ReleaseService releaseService) {
        this.releaseService = releaseService;
    }

    @Timed
    public String getReleaseTitleFromChild(String childId) {
        if (childId == null) {
            return null;
        }

        return getReleaseTitle(Ids.releaseIdFrom(childId));
    }

    @Timed
    public String getReleaseTitle(String id) {
        if (id == null) {
            return null;
        }

        String title = null;
        try {
            title = releaseService.getTitle(id);
        } catch (NotFoundException e) {
            logger.warn("Could not find release with ID {} to resolve its title", id);
        }

        return title;
    }

}
