package com.xebialabs.xlrelease.repository

import com.xebialabs.xlrelease.domain.status.ReleaseStatus
import com.xebialabs.xlrelease.repository.ReleaseSearchByParams.ParentOrAncestor

case class ReleaseSearchByParams(page: Page,
                                 folderId: ParentOrAncestor = null,
                                 statuses: Array[ReleaseStatus],
                                 title: String = null,
                                 rootReleaseId: String = null,
                                 autoStart: Boolean = false)

object ReleaseSearchByParams {
  type ParentOrAncestor = Either[String, String]
  
  type ByParent = Left[String, String]
  type ByAncestor = Right[String, String]

  def byParent(folderId: String): ByParent = Left(folderId)
  
  def byAncestor(folderId: String): ByAncestor = Right(folderId)
}
