package com.xebialabs.xlrelease.upgrade.db

import com.xebialabs.deployit.repository.WorkDirContext
import com.xebialabs.deployit.server.api.upgrade.{Upgrade, Version}
import com.xebialabs.xlrelease.config.XlrConfig
import com.xebialabs.xlrelease.export.TemplateImporter
import com.xebialabs.xlrelease.initialize.TutorialsFolderInitializer.SAMPLES_AND_TUTORIALS_FOLDER_ID
import com.xebialabs.xlrelease.initialize.{SampleTemplatesInitialization, TutorialsFolderInitializer}
import com.xebialabs.xlrelease.service.FolderService
import com.xebialabs.xlrelease.template.SamplesImporter
import com.xebialabs.xlrelease.upgrade.Components.XL_RELEASE_COMPONENT
import grizzled.slf4j.Logging
import org.springframework.beans.factory.annotation.Autowired
import org.springframework.stereotype.Component

import scala.jdk.CollectionConverters._

@Component
class XLRelease800DeploymentSamplesUpgrade @Autowired()(foldersService: FolderService,
                                                        xlrConfig: XlrConfig,
                                                        tutorials: TutorialsFolderInitializer,
                                                        val workDirContext: WorkDirContext,
                                                        val templateImporter: TemplateImporter)
  extends Upgrade with SamplesImporter with Logging {

  override def upgradeVersion(): Version = Version.valueOf(XL_RELEASE_COMPONENT, "8.0.0#2")

  val templates = Map(
    "templates/blue-green.json" -> SampleTemplatesInitialization.TEMPLATE_BLUE_GREEN_ID,
    "templates/canary.json" -> SampleTemplatesInitialization.TEMPLATE_CANARY_ID
  )

  override def doUpgrade(): Boolean = {
    logger.info("Importing new samples for XLR 8.0.0")
    addNewSamplesTemplates()
    true
  }

  private def addNewSamplesTemplates(): Unit = {
    if (xlrConfig.initialization_createSampleTemplates) {

      // only add the new templates if the template folder exists
      if (foldersService.exists(SAMPLES_AND_TUTORIALS_FOLDER_ID)) {
        importSampleTemplates(templates.asJava)
        tutorials.moveSampleTemplates(templates.values.toSeq)
      }
    }
  }

}
