package com.xebialabs.xlrelease.features.settings

import com.xebialabs.deployit.plugin.api.udm.Metadata
import com.xebialabs.xlrelease.configuration.FeatureSettings
import com.xebialabs.xlrelease.utils.XLTypes.XLProperty

import scala.beans.BeanProperty

@Metadata(label = "Custom script task",
  description = "Customize custom script task behavior."
)
class CustomScriptTaskSettings extends FeatureSettings {
  @BeanProperty
  @XLProperty(label = "Preserve output property and variable values for Custom script tasks",
    description = "When checked, if a Custom script task fails without an exception, the values of the output property and variable set before the failure will be preserved. This setting is global and applies to all Custom script tasks",
    category = "input",
    defaultValue = "false")
  var preserveOutputVariables: Boolean = _

  @BeanProperty
  @XLProperty(defaultValue = "script", hidden = true)
  var displayIcon: String = _

  @BeanProperty
  @XLProperty(defaultValue = "tasks-settings", hidden = true)
  var displayPage: String = _

  @BeanProperty
  @XLProperty(defaultValue = "how-to/configure-tasks.html", hidden = true)
  var documentationPage: String = _

  @XLProperty(defaultValue = "30", hidden = true)
  var weight: Integer = _
}
