package com.xebialabs.xlrelease.domain.variables

import com.xebialabs.deployit.plugin.api.reflect.Type
import com.xebialabs.xlrelease.domain.BaseConfiguration
import com.xebialabs.xlrelease.domain.variables.GlobalVariables.GLOBAL_VARIABLES_ID
import com.xebialabs.xlrelease.repository.{ConfigurationRepository, Ids}

import scala.jdk.CollectionConverters.CollectionHasAsScala
import scala.util.Try

trait ConfigurationValueProvider[+T <: BaseConfiguration] extends ReferenceCiVariableProvider[T] {
  val configurationRepository: ConfigurationRepository

  override def getRawValue(variable: ReferenceVariable): Option[T] = {
    Try(configurationRepository.read[T](variable.getValue)).toOption
  }

  override def possibleValues(valueProviderConfiguration: CiProvider): Seq[PossibleValue] = {
    val variable = valueProviderConfiguration.getVariable.asInstanceOf[ReferenceVariable]

    val folderId = Option(variable.getFolderId).orElse {
      Option(variable.getId).filterNot(_.startsWith(GLOBAL_VARIABLES_ID)).map(Ids.findFolderId)
    }

    configurationRepository
      .findAllByTypeAndTitle[T](Type.valueOf(variable.getReferencedType), null, folderId.orNull, folderOnly = false)
      .asScala
      .map(configuration => new PossibleValue(configuration.getId, configuration.getTitle))
      .toSeq
  }
}
