/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.limits;

import com.xebialabs.xlrelease.configuration.TenantLimit;
import com.xebialabs.xlrelease.exception.RateLimitReachedException;
import com.xebialabs.xlrelease.repository.TenantLimitRepository;
import java.util.function.IntSupplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class LimitEnforcer {
    private static final Logger logger = LoggerFactory.getLogger(LimitEnforcer.class);
    private final TenantLimitRepository tenantLimitRepository;

    public LimitEnforcer(TenantLimitRepository tenantLimitRepository) {
        this.tenantLimitRepository = tenantLimitRepository;
    }

    public void enforceLimit(String tenantId, LimitType limitType, int increment, IntSupplier currentCountSupplier) {
        TenantLimit tenantLimit = this.tenantLimitRepository.getEffectiveLimit(tenantId);
        if (!tenantLimit.isEnabled()) {
            logger.debug("Limit enforcement is disabled for tenant: {}", (Object)tenantId);
            return;
        }
        int limit = this.getConfiguredLimit(limitType, tenantLimit);
        if (limit < 0) {
            logger.debug("Unlimited {} allowed for tenant: {}", (Object)limitType.getResourceName(), (Object)tenantId);
            return;
        }
        int currentCount = currentCountSupplier.getAsInt();
        if (currentCount + increment > limit) {
            String message = this.buildLimitExceededMessage(limitType, currentCount, limit);
            throw new RateLimitReachedException(message);
        }
        logger.debug("Limit enforcement passed for tenant {}: {} {}/{}", new Object[]{tenantId, limitType.getResourceName(), currentCount, limit});
    }

    private int getConfiguredLimit(LimitType limitType, TenantLimit tenantLimit) {
        return switch (limitType.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> tenantLimit.getMaxFolders();
            case 1 -> tenantLimit.getMaxConnections();
            case 2 -> tenantLimit.getMaxTemplates();
            case 3 -> tenantLimit.getMaxRunningReleases();
            case 8 -> tenantLimit.getMaxWorkflowTemplates();
            case 9 -> tenantLimit.getMaxWorkflowExecutions();
            case 14 -> tenantLimit.getMaxTriggers();
            case 15 -> tenantLimit.getMaxPatterns();
            case 16 -> tenantLimit.getMaxDeliveries();
            case 4 -> tenantLimit.getMaxTemplatePhases();
            case 5 -> tenantLimit.getMaxTemplateTasks();
            case 6 -> tenantLimit.getMaxReleasePhases();
            case 7 -> tenantLimit.getMaxReleaseTasks();
            case 10 -> tenantLimit.getMaxWorkflowPhases();
            case 11 -> tenantLimit.getMaxWorkflowTasks();
            case 12 -> tenantLimit.getMaxWorkflowExecutionPhases();
            case 13 -> tenantLimit.getMaxWorkflowExecutionTasks();
            case 17 -> tenantLimit.getMaxApplications();
            case 18 -> tenantLimit.getMaxEnvironments();
        };
    }

    private String buildLimitExceededMessage(LimitType limitType, int actual, int limit) {
        return String.format("%s limit reached (%d of %d used). You cannot add more %s.", limitType.getDisplayName(), actual, limit, limitType.getDisplayName().toLowerCase());
    }

    public static enum LimitType {
        FOLDERS("Folders", "folders"),
        CONNECTIONS("Connections", "connections"),
        TEMPLATES("Templates", "templates"),
        RELEASES("Running releases", "running releases"),
        TEMPLATE_PHASES("Template phases", "template phases"),
        TEMPLATE_TASKS("Template tasks", "template tasks"),
        RELEASE_PHASES("Release phases", "release phases"),
        RELEASE_TASKS("Release tasks", "release tasks"),
        WORKFLOW_TEMPLATES("Workflow templates", "workflow templates"),
        WORKFLOW_EXECUTIONS("Workflow executions", "workflow executions"),
        WORKFLOW_PHASES("Workflow phases", "workflow phases"),
        WORKFLOW_TASKS("Workflow tasks", "workflow tasks"),
        WORKFLOW_EXECUTION_PHASES("Workflow execution phases", "workflow execution phases"),
        WORKFLOW_EXECUTION_TASKS("Workflow execution tasks", "workflow execution tasks"),
        TRIGGERS("Triggers", "triggers"),
        PATTERNS("Patterns", "patterns"),
        DELIVERIES("Deliveries", "deliveries"),
        APPLICATIONS("Applications", "applications"),
        ENVIRONMENTS("Environments", "environments");

        private final String displayName;
        private final String resourceName;

        private LimitType(String displayName, String resourceName) {
            this.displayName = displayName;
            this.resourceName = resourceName;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public String getResourceName() {
            return this.resourceName;
        }
    }
}

