package com.xebialabs.xlrelease.service;

import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

import com.xebialabs.deployit.exception.NotFoundException;
import com.xebialabs.deployit.security.UserService;

import io.micrometer.core.annotation.Timed;

@Repository
public class Users {

    private UserService userService;

    @Autowired
    public Users(UserService userService) {
        this.userService = userService;
    }

    @Timed
    public List<String> getRepositoryUsernames() {
        return userService.listUsernames();
    }

    @Timed
    public boolean userExistsInRepository(String username) {
        try {
            userService.read(username);
            return true;
        } catch (NotFoundException e) {
            return false;
        }
    }

}
