package com.xebialabs.xlrelease.features.settings

import com.xebialabs.deployit.plugin.api.udm.Metadata
import com.xebialabs.xlrelease.configuration.FeatureSettings
import com.xebialabs.xlrelease.utils.XLTypes.XLProperty

import scala.beans.BeanProperty

@Metadata(label = "Gate task",
  description = "Enable the Gate task to transition to the Failing status if any dependency fails."
)
class GateTaskFailingFeatureSettings extends FeatureSettings {

  @BeanProperty
  @XLProperty(label = "Enable Failing status for Gate task",
    description = "Gate task will transition to the Failing status when there are failed dependencies.",
    category = "input",
    defaultValue = "true")
  var gateTaskFailingEnabled: Boolean = _

  @BeanProperty
  @XLProperty(defaultValue = "experimental", hidden = true)
  var displayPage: String = _

  @BeanProperty
  @XLProperty(defaultValue = "how-to/configure-experimental-settings.html", hidden = true)
  var documentationPage: String = _

  @XLProperty(defaultValue = "30", hidden = true)
  var weight: Integer = _
}
