package com.xebialabs.xlrelease.views.converters;

import java.util.List;
import java.util.Map;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import com.xebialabs.xlrelease.service.UserInfoResolver;
import com.xebialabs.xlrelease.user.User;
import com.xebialabs.xlrelease.views.UserView;

import static com.xebialabs.xlrelease.variable.VariableHelper.containsVariables;
import static java.util.stream.Collectors.toList;

@Component
public class UserViewConverter {

    private UserInfoResolver userInfoResolver;

    @Autowired
    public void setUserInfoResolver(final UserInfoResolver userInfoResolver) {
        this.userInfoResolver = userInfoResolver;
    }

    public UserView toUserView(String username, boolean resolveWithDataProvider) {
        String fullName = null;
        if (username != null && !containsVariables(username)) {
            fullName = userInfoResolver.getFullNameOf(username, resolveWithDataProvider);
        }
        return new UserView(username, fullName);
    }

    public UserView toUserView(String username) {
        return toUserView(username, true);
    }

    public List<UserView> toUserView(final List<String> principals, Map<String, UserView> cache, boolean resolveWithDataProvider) {
        return principals.stream().map(principal ->
                cache.computeIfAbsent(principal, username ->
                        toUserView(username, resolveWithDataProvider))).collect(toList());
    }

    public UserView toFullView(User user) {
        return toUserView(user.getName());
    }

}
