package com.xebialabs.xlrelease.views.converters;

import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import com.xebialabs.deployit.security.Role;
import com.xebialabs.deployit.security.RoleService;
import com.xebialabs.xlrelease.api.v1.views.TeamMemberView;
import com.xebialabs.xlrelease.service.UserInfoResolver;

import static com.xebialabs.xlrelease.api.v1.views.TeamMemberView.MemberType.PRINCIPAL;
import static com.xebialabs.xlrelease.api.v1.views.TeamMemberView.MemberType.ROLE;
import static java.util.stream.Collectors.toList;

@Component
public class TeamMemberViewConverter {

    private final UserInfoResolver userInfoResolver;

    private final RoleService roleService;

    @Autowired
    public TeamMemberViewConverter(UserInfoResolver userInfoResolver, RoleService roleService) {
        this.userInfoResolver = userInfoResolver;
        this.roleService = roleService;
    }

    public TeamMemberView toView(String name, TeamMemberView.MemberType type) {
        TeamMemberView teamMemberView = new TeamMemberView();
        teamMemberView.setName(name);
        teamMemberView.setType(type);
        if (type == PRINCIPAL) {
            teamMemberView.setFullName(userInfoResolver.getFullNameOf(name));
        } else if (type == ROLE) {
            List<Role> roles = getRoles(name);
            if (!roles.isEmpty()) {
                teamMemberView.setRoleId(roles.get(0).getId());
            }
        }
        return teamMemberView;
    }

    private List<Role> getRoles(final String name) {
        return roleService.getRoles().stream().filter(role -> role.getName().equalsIgnoreCase(name)).collect(toList());
    }
}
