package com.xebialabs.xlrelease.actors.utils

import com.xebialabs.xlplatform.cluster.ClusterMode.Full
import com.xebialabs.xlrelease.actors.ActorSystemHolder
import com.xebialabs.xlrelease.config.XlrConfig
import org.apache.pekko.actor.{ActorSystem, PoisonPill}
import org.springframework.context.annotation.Lazy
import org.springframework.stereotype.Component

import scala.concurrent.Await

@Component
class TriggerActorLifecycleUtils(@Lazy actorSystemHolder: ActorSystemHolder) extends ActorLifecycleUtils {

  import scala.concurrent.duration._

  def terminateAllTriggerActors(): Unit = {
    terminateActors("*")
  }

  private def terminateActors(actorPath: String): String = {
    lazy implicit val system: ActorSystem = actorSystemHolder.unmanagedActorSystem
    val terminationResult = findAndTerminate(toActorPath(actorPath), terminationMsg = Some(PoisonPill))
    Await.result(terminationResult, 5.seconds)
  }

  private def toActorPath(path: String): String = {
    if (path.startsWith("/")) {
      path
    } else if (XlrConfig.getInstance.clusterMode == Full) {
      s"/system/sharding/trigger-processing-actor/*/$path"
    } else {
      s"/user/trigger-processing-actor/$path"
    }
  }

}
