package com.xebialabs.xlrelease.upgrade.liquibase

import com.xebialabs.deployit.server.api.upgrade.Version
import com.xebialabs.xlplatform.upgrade.RepositoryVersionService
import com.xebialabs.xlrelease.upgrade.Components.XL_RELEASE_COMPONENT
import grizzled.slf4j.Logging
import org.springframework.stereotype.Component

/**
 * Fix Release version which was modified by AttachmentReleaseBackreferenceJsonUpgrade on 9.7.x, 10.0.x and 10.1.x branches
 * see https://digitalai.atlassian.net/browse/FI-818
 */
@Component
class XLRelease102BeforeUpgrade(var repositoryVersionService: RepositoryVersionService)
  extends BeforeUpgrade with Logging {

  override protected def xlReleaseVersion(): Version = Version.valueOf(XL_RELEASE_COMPONENT, "10.2.0#3")

  override protected def doUpgrade(): Unit = {
    logger.info("applying upgrade XLRelease102BeforeUpgrade")
    //Read audit plugin version for previous release version as it is a bundled plugin
    val auditPluginVersion = repositoryVersionService.readVersionOfComponent("xlr-audit-plugin")

    if (null != auditPluginVersion) {
      val major = auditPluginVersion.getMajor
      val minor = auditPluginVersion.getMinor
      if (major == 9 && minor == 7) {
        logger.info("Setting previous release version to '9.7.0#7'")
        updateReleaseVersion("9.7.0#7")
      } else if (major == 10 && minor == 0) {
        logger.info("Setting previous release version to '10.0.0#5'")
        updateReleaseVersion("10.0.0#5")
      } else if (major == 10 && minor == 1) {
        logger.info("Setting previous release version to '10.1.0#4'")
        updateReleaseVersion("10.1.0#4")
      }
    }
  }

  private def updateReleaseVersion(version: String): Unit = {
    val newReleaseVersion = Version.valueOf(XL_RELEASE_COMPONENT, version)
    repositoryVersionService.storeVersionOfComponent(newReleaseVersion)
  }
}
