package com.xebialabs.xlrelease

import com.xebialabs.deployit.ServerConfigFile
import com.xebialabs.deployit.plumbing.CurrentVersion
import com.xebialabs.plugin.manager.cli.PluginManagerCliLaunchOptions.parseCommandLine
import com.xebialabs.plugin.manager.cli.{PluginManagerCli, PluginManagerCliLaunchOptions}
import com.xebialabs.plugin.manager.config.PluginManagerProperties
import com.xebialabs.plugin.manager.metadata.XLProduct.XLRelease
import com.xebialabs.plugin.manager.repository.sql.SqlPluginRepository
import com.xebialabs.xlrelease.XLReleaseBootstrapper.releaseServer
import com.xebialabs.xlrelease.config.XlrConfig
import com.xebialabs.xlrelease.pluginmanager.XlrPluginManagerProps
import com.zaxxer.hikari.{HikariConfig, HikariDataSource}
import org.springframework.jdbc.core.JdbcTemplate
import org.springframework.util.ResourceUtils

object PluginManagerCliBootstrapper {

  def main(args: Array[String]): Unit = {
    val cliLaunchOptions = parseCommandLine(args)
    if (cliLaunchOptions == null) {
      System.exit(0)
    }

    val serverLaunchOptions = new XLReleaseServerLaunchOptions

    val serverConfFile = ResourceUtils.getFile(XlrConfig.bootConfig.confFile_location)
    val confFile = new ServerConfigFile(serverConfFile)

    releaseServer = new ReleaseServer(serverLaunchOptions, confFile)
    releaseServer.prepareConfigs()

    runPluginManagerCli(cliLaunchOptions)

    System.exit(0)
  }

  def runPluginManagerCli(options: PluginManagerCliLaunchOptions): Unit = {
    val ds = dataSource()
    val repository = sqlPluginRepository(ds)
    val xlrPluginManagerProps = getXlrPluginManagerProps
    val cli = pluginManagerCli(xlrPluginManagerProps, repository)
    val output = cli.run(options)
    println(output)
    ds.close()
  }

  def dataSource(): HikariDataSource = {
    val xlrConfig = XlrConfig.getInstance
    val cfg = new HikariConfig()
    cfg.setDriverClassName(xlrConfig.xlrRepositoryDriver)
    cfg.setJdbcUrl(xlrConfig.xlrRepositoryJdbcUrl)
    cfg.setUsername(xlrConfig.xlrRepositoryUsername)
    cfg.setPassword(xlrConfig.xlrRepositoryPassword)
    new HikariDataSource(cfg)
  }

  private def getXlrPluginManagerProps: XlrPluginManagerProps = {
    val xlrConfig = XlrConfig.getInstance
    val repository = xlrConfig.getXl.getConfig("features").getConfig("plugins").getConfig("repositories").getConfig("xlr-official")
    val servers = xlrConfig.getXl.getConfig("features").getConfig("plugins").getConfig("servers").getConfig("xebialabs-plugins")

    val proxyConfig = if (servers.hasPath("proxy")) servers.getConfig("proxy") else null
    val proxyHost = if (proxyConfig != null && proxyConfig.hasPath("host")) proxyConfig.getString("host") else ""
    val proxyPort = if (proxyConfig != null && proxyConfig.hasPath("port")) proxyConfig.getInt("port") else 0
    val proxyUsername = if (proxyConfig != null && proxyConfig.hasPath("credentials")) proxyConfig.getConfig("credentials").getString("username") else ""
    val proxyPassword = if (proxyConfig != null && proxyConfig.hasPath("credentials")) proxyConfig.getConfig("credentials").getString("password") else ""


    val xlrPluginManagerProps = new XlrPluginManagerProps(
      servers.getString("server-type"),
      servers.getString("url"),
      servers.getConfig("credentials").getString("username"),
      servers.getConfig("credentials").getString("password"),
      proxyHost,
      proxyPort,
      proxyUsername,
      proxyPassword,
      repository.getString("repository-type"),
      repository.getString("server-ref"),
      repository.getString("nexus-repository-id"),
      repository.getString("nexus-group-id"),
      repository.getConfig("nexus-metadata-artifact").getString("group-id"),
      repository.getConfig("nexus-metadata-artifact").getString("artifact-id"),
      repository.getString("xl-component"),
      repository.getString("enabled")
    )
    xlrPluginManagerProps
  }

  def sqlPluginRepository(dataSource: HikariDataSource): SqlPluginRepository = new SqlPluginRepository(new JdbcTemplate(dataSource))

  def pluginManagerCli(pluginManagerProperties: PluginManagerProperties, sqlPluginRepository: SqlPluginRepository): PluginManagerCli =
    new PluginManagerCli(pluginManagerProperties, sqlPluginRepository, XLRelease, CurrentVersion.get, XlrConfig.getInstance.features.plugins.checkJdk17CompatibilityOnPluginInstall)

}

