package com.xebialabs.xlrelease.support.report

import com.fasterxml.jackson.databind.ObjectMapper
import com.xebialabs.xlrelease.scheduler.filters.JobFilters
import com.xebialabs.xlrelease.scheduler.repository.JobRepository
import com.xebialabs.xlplatform.support.report.SupportPackageFileWriter.writeToFile
import grizzled.slf4j.Logging
import org.springframework.data.domain.Pageable
import org.springframework.stereotype.Service

@Service
class TaskManagerInformationService(jobRepository: JobRepository, objectMapper: ObjectMapper) extends Logging {

  def writeTaskManagerReport(): Unit = {
    writeToFile(s"log/$TASK_MANAGER_INFORMATION_FILE_NAME", generateJsonReport())
  }

  private[support] def generateJsonReport(): String = {
    val entriesList = jobRepository.findAllJobOverview(new JobFilters(), Pageable.unpaged())
    objectMapper.writeValueAsString(entriesList)
  }
}
