package com.xebialabs.xlrelease.script;

import java.io.IOException;
import java.io.Writer;
import java.util.stream.Collector;
import org.apache.commons.collections4.queue.CircularFifoQueue;

public class RingWriter extends Writer {
    private CircularFifoQueue<Character> queue;

    public RingWriter(int size) {
        queue = new CircularFifoQueue<>(size);
    }

    @Override
    public void write(final char[] cbuf, final int off, final int len) throws IOException {
        for (int i = off; i < len; ++i) {
            queue.add(cbuf[i]);
        }
    }

    @Override
    public void flush() throws IOException {
        // do nothing
    }

    @Override
    public void close() throws IOException {
        // do nothing
    }

    @Override
    public String toString() {
        return queue.stream().collect(Collector.of(
                StringBuilder::new,
                StringBuilder::append,
                StringBuilder::append,
                StringBuilder::toString));
    }
}
