package com.xebialabs.xlrelease.views;

import com.xebialabs.xlrelease.domain.PlanItem;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.Task;
import com.xebialabs.xlrelease.domain.status.FlagStatus;

import static com.xebialabs.xlrelease.domain.status.FlagStatus.OK;

public class Flag {
    private FlagStatus status;
    private String comment;

    public Flag() {}

    public Flag(FlagStatus status) {
        this.status = status;
    }

    public Flag(FlagStatus status, String comment) {
        this.status = status;
        this.comment = comment;
    }

    public FlagStatus getStatus() {
        return status;
    }

    public void setStatus(FlagStatus status) {
        this.status = status;
    }

    public String getComment() {
        return comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public static Flag toItemFlag(PlanItem item) {
        return new Flag(item.getFlagStatus(), item.getFlagComment());
    }

    public static Flag toFlag(Release release) {
        if (release.getFlagStatus() != OK) {
            return new Flag(release.getFlagStatus(), release.getFlagComment());
        }

        for (Task task : release.getAllTasks()) {
            if (task.isFlagged()) {
                return new Flag(task.getFlagStatus(), task.getFlagComment());
            }
        }

        if (release.getRealFlagStatus() != OK) {
            return new Flag(release.getRealFlagStatus(), null);
        }

        return new Flag(OK, release.getFlagComment());
    }
}
