package com.xebialabs.xlrelease.metrics

import io.micrometer.core.instrument.binder.MeterBinder
import io.micrometer.core.instrument.{Gauge, MeterRegistry}
import org.springframework.boot.actuate.health.{HealthEndpoint, Status}

class HealthMetricsMeterBinder(healthEndpoint: HealthEndpoint) extends MeterBinder {

  private def getStatusCode(health: HealthEndpoint): Int = {
    val status = health.health.getStatus
    status match {
      case Status.UP => 1
      case _ => 0
    }
  }

  override def bindTo(registry: MeterRegistry): Unit = {
    Gauge.builder("health", healthEndpoint, this.getStatusCode).strongReference(true).register(registry)
  }
}
