package com.xebialabs.xlrelease.spring.configuration;

import org.springframework.boot.actuate.autoconfigure.availability.AvailabilityProbesAutoConfiguration;
import org.springframework.boot.actuate.availability.ReadinessStateHealthIndicator;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.availability.ApplicationAvailability;
import org.springframework.context.annotation.Bean;

import com.xebialabs.xlrelease.health.XlrReadinessStateHealthIndicator;
import com.xebialabs.xlrelease.service.XlrServiceManager;

@AutoConfiguration(
        after = {AvailabilityProbesAutoConfiguration.class}
)
@ConditionalOnBean(AvailabilityProbesAutoConfiguration.class)
public class XlrReadinessProbeConfiguration {

    @Bean("readinessStateHealthIndicator")
    public ReadinessStateHealthIndicator readinessStateHealthIndicator(
            ApplicationAvailability applicationAvailability,
            XlrServiceManager xlrServiceManager) {
        return new XlrReadinessStateHealthIndicator(applicationAvailability, xlrServiceManager);
    }
}
