package com.xebialabs.xlrelease.service;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.xebialabs.xlrelease.domain.UserProfile;

import io.micrometer.core.annotation.Timed;

import static com.google.common.base.Strings.nullToEmpty;
import static com.xebialabs.deployit.booter.local.utils.Strings.isEmpty;

@Service
public class UserInfoResolver {

    private UserProfileService userProfileService;

    @Autowired
    public UserInfoResolver(UserProfileService userProfileService) {
        this.userProfileService = userProfileService;
    }

    @Timed
    public String getNotificationEmailOf(String username) {
        if (isUndefined(username)) {
            return null;
        }

        // Force the creation of a UserProfile for all principals.
        // The rationale is that some principals can be LDAP groups, that we currently
        // don't resolve automatically to email address(es). So we leave an empty profile
        // that the admin can fill with a global address for this group (assuming such an
        // address exists).
        UserProfile profile = userProfileService.discover(username);
        return (profile == null) ? null : profile.getEmail();
    }

    @Timed
    public String getFullNameOf(String username, boolean resolveWithDataProvider) {
        if (isUndefined(username)) {
            return null;
        }

        UserProfile profile = userProfileService.resolveUserProfile(username, resolveWithDataProvider);
        return (profile == null) ? null : profile.getFullName();
    }

    @Timed
    public String getFullNameOf(String username) {
        return getFullNameOf(username, true);
    }

    @Timed
    public String getFullNameOrUsernameOf(String username) {
        String fullName = getFullNameOf(username);
        return getFullNameOrUsernameOf(username, fullName);
    }

    public static String getFullNameOrUsernameOf(String username, String fullName) {
        return isUndefined(fullName) ? username : fullName;
    }

    private static boolean isUndefined(String username) {
        return isEmpty(nullToEmpty(username).trim());
    }
}
