package com.xebialabs.xlrelease.repository

import com.xebialabs.xlrelease.domain.{Datacenter, DatacenterTargetState}

trait DatacenterRepository {

  def find(datacenter: String): Option[Datacenter]

  def findAll(): Seq[Datacenter]

  def count(): Long

  def delete(datacenter: String): Unit

  def create(datacenter: String, state: DatacenterTargetState, createdBy: String): Datacenter

  def update(datacenter: String, state: DatacenterTargetState, updatedBy: String): Unit
}
