package com.xebialabs.xlrelease.repository

import com.xebialabs.deployit.plugin.api.reflect.Type
import com.xebialabs.xlrelease.domain.Trigger
import com.xebialabs.xlrelease.repository.sql.InterceptedRepository
import com.xebialabs.xlrelease.repository.sql.persistence.CiUid
import org.springframework.data.domain.{Pageable, Page => SPage}

trait TriggerRepository extends InterceptedRepository[Trigger] {

  def find[T <: Trigger](triggerId: String): T

  def create[T <: Trigger](trigger: T): T

  def update[T <: Trigger](trigger: T): T

  def delete(triggerId: String): Unit

  def findByFolderId(folderId: String, nestedFolders: Boolean, pageable: Pageable): SPage[Trigger]

  def numberOfTemplateTriggers(templateId: String): Int

  def findByTemplateId(templateId: String, pageable: Pageable): SPage[Trigger]

  def findByType(triggerTypes: List[Type], pageable: Pageable): SPage[Trigger]

  def registerPersistenceInterceptor(persistenceInterceptor: PersistenceInterceptor[Trigger]): Unit

  def getRunningTriggeredReleasesCount(templateCiUId: CiUid): Int

  def insertTriggeredRelease(templateUid: CiUid, triggerUid: CiUid, triggeredReleaseUid: CiUid): Unit

  def removeTriggeredRelease(condition: RemoveTriggeredReleaseCondition): Unit

  def getTenantIdForTrigger(triggerId: String): String
}

sealed trait RemoveTriggeredReleaseCondition

case class RemoveByTemplateUid(templateUid: CiUid) extends RemoveTriggeredReleaseCondition

case class RemoveByReleaseUid(releaseUid: CiUid) extends RemoveTriggeredReleaseCondition
