package com.xebialabs.xlrelease.db.sql.archiving

import com.xebialabs.xlrelease.db.ArchivedReleases._
import com.xebialabs.xlrelease.db.sql.Sql
import com.xebialabs.xlrelease.db.sql.SqlBuilder.Dialect

class SelectArchivedReleasesBuilder(columns: String*)(implicit dialect: Dialect)
  extends BaseSelectArchivedBuilder[SelectArchivedReleasesBuilder](REPORT_RELEASES_TABLE_NAME, REPORT_RELEASES_TABLE_ALIAS, columns: _*) {

  def withTitle(title: String): SelectArchivedReleasesBuilder = {
    like(s"$alias.$REPORT_RELEASES_TITLE_COLUMN", title)
  }

  def withOwner(owner: String): SelectArchivedReleasesBuilder = {
    if (owner != null) {
      conditions += Sql(s"$alias.$REPORT_RELEASES_OWNER_COLUMN = ?", Seq(owner))
    }
    this
  }

  def withNonOkFlag(): SelectArchivedReleasesBuilder = {
    conditions += Sql(s"$alias.$REPORT_RELEASES_IS_FLAGGED_COLUMN = 1", Seq())
    this
  }

  def withReleaseIds(releaseIds: Seq[String]): SelectArchivedReleasesBuilder = {
    if (releaseIds.isEmpty) {
      throw new IllegalStateException("empty list is not allowed")
    }
    conditions += Sql(s"$alias.$REPORT_RELEASES_ID_COLUMN IN (${releaseIds.map(_ => "?").mkString(",")})", releaseIds)
    this
  }

  override def newInstance: SelectArchivedReleasesBuilder = new SelectArchivedReleasesBuilder(columns: _*)
}
