package com.xebialabs.xlrelease.db.sql

import com.xebialabs.xlrelease.db.sql.DatabaseInfo._
import com.xebialabs.xlrelease.db.sql.SqlBuilder._
import grizzled.slf4j.Logging
import org.springframework.jdbc.core.JdbcTemplate

import javax.sql.DataSource

class SqlDialectDetector extends Logging {

  def detectSqlDialect(jdbcTemplate: JdbcTemplate): Dialect = {
    val ds = jdbcTemplate.getDataSource
    detectSqlDialect(ds)
  }

  def detectSqlDialect(dataSource: DataSource): Dialect = {
    val dbInfo = DatabaseInfo(dataSource)
    detectSqlDialect(dbInfo)
  }

  def detectSqlDialect(dbInfo: DatabaseInfo): Dialect = {
    logger.debug(s"Detecting SQL dialect for ${dbInfo.dbName}")
    val dialect = dbInfo match {
      case Derby(_) => DerbyDialect(dbInfo.dbName)
      case Oracle(_) => OracleDialect(dbInfo.dbName)
      case Db2(_) => Db2Dialect(dbInfo.dbName)
      case MsSqlServer(_) => MSSQLDialect(dbInfo.dbName)
      case MySql(_) => CommonDialect(dbInfo.dbName)
      case H2(_) => CommonDialect(dbInfo.dbName)
      case PostgreSql(_) => CommonDialect(dbInfo.dbName)
      case _ => logger.warn(s"${dbInfo.dbName} is not officially supported.")
        CommonDialect(dbInfo.dbName)
    }
    logger.info(s"SQL dialect for ${dbInfo.dbName} is $dialect")
    dialect
  }
}
