package com.xebialabs.xlrelease.views;

import java.util.List;

import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.views.converters.TeamMemberViewConverter;

import static java.util.stream.Collectors.toList;

public class ReleasePermissionsView {
    private List<String> permissions;
    private List<TeamView> teams;

    public ReleasePermissionsView(List<String> permissions, Release release, TeamMemberViewConverter teamMemberViewConverter) {
        this.permissions = permissions;
        this.teams = release.getTeams().stream().map(team -> new TeamView(team, teamMemberViewConverter)).collect(toList());
    }

    public List<String> getPermissions() {
        return permissions;
    }

    public List<TeamView> getTeams() {
        return teams;
    }
}
