/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.service;

import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.xlrelease.db.sql.transaction.IsTransactional;
import com.xebialabs.xlrelease.domain.Attachment;
import com.xebialabs.xlrelease.domain.Changes;
import com.xebialabs.xlrelease.domain.Comment;
import com.xebialabs.xlrelease.domain.Dependency;
import com.xebialabs.xlrelease.domain.GateTask;
import com.xebialabs.xlrelease.domain.PlanItem;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.Task;
import com.xebialabs.xlrelease.domain.events.AttachmentCreatedEvent;
import com.xebialabs.xlrelease.domain.events.XLReleaseEvent;
import com.xebialabs.xlrelease.domain.facet.Facet;
import com.xebialabs.xlrelease.events.XLReleaseEventBus;
import com.xebialabs.xlrelease.repository.AttachmentRepository;
import com.xebialabs.xlrelease.repository.DependencyTargetResolver;
import com.xebialabs.xlrelease.repository.FacetRepository;
import com.xebialabs.xlrelease.repository.FacetRepositoryDispatcher;
import com.xebialabs.xlrelease.repository.PhaseRepository;
import com.xebialabs.xlrelease.repository.ReleaseRepository;
import com.xebialabs.xlrelease.repository.TaskRepository;
import com.xebialabs.xlrelease.service.AttachmentService;
import com.xebialabs.xlrelease.service.ChangeExecutionService$;
import com.xebialabs.xlrelease.service.ChangeProcessor;
import com.xebialabs.xlrelease.service.CommentService;
import com.xebialabs.xlrelease.user.User;
import com.xebialabs.xlrelease.utils.CloseableUtils$;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.InputStream;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.Collection;
import org.joda.time.DateTime;
import org.slf4j.Marker;
import org.springframework.stereotype.Service;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option$;
import scala.PartialFunction;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;

@Service
@ScalaSignature(bytes="\u0006\u0005\u0005Mf\u0001B\u000e\u001d\u0001\u0015B\u0001\u0002\u000f\u0001\u0003\u0006\u0004%\t!\u000f\u0005\t{\u0001\u0011\t\u0011)A\u0005u!Aa\b\u0001BC\u0002\u0013\u0005q\b\u0003\u0005D\u0001\t\u0005\t\u0015!\u0003A\u0011!!\u0005A!b\u0001\n\u0003)\u0005\u0002\u0003'\u0001\u0005\u0003\u0005\u000b\u0011\u0002$\t\u00115\u0003!Q1A\u0005\u00029C\u0001B\u0015\u0001\u0003\u0002\u0003\u0006Ia\u0014\u0005\t'\u0002\u0011)\u0019!C\u0001)\"A\u0001\f\u0001B\u0001B\u0003%Q\u000b\u0003\u0005Z\u0001\t\u0015\r\u0011\"\u0001[\u0011!q\u0006A!A!\u0002\u0013Y\u0006\u0002C0\u0001\u0005\u000b\u0007I\u0011\u00011\t\u0011\u0011\u0004!\u0011!Q\u0001\n\u0005D\u0001\"\u001a\u0001\u0003\u0006\u0004%\tA\u001a\u0005\t[\u0002\u0011\t\u0011)A\u0005O\"Aa\u000e\u0001BC\u0002\u0013\u0005q\u000e\u0003\u0005t\u0001\t\u0005\t\u0015!\u0003q\u0011\u0015!\b\u0001\"\u0001v\u0011\u001d\t\t\u0001\u0001C\u0001\u0003\u0007Aq!a\u0010\u0001\t\u0013\t\t\u0005C\u0004\u0002F\u0001!I!a\u0012\t\u000f\u0005-\u0003\u0001\"\u0003\u0002N!9\u0011q\u0011\u0001\u0005\n\u0005%\u0005bBAG\u0001\u0011E\u0011q\u0012\u0005\b\u0003/\u0003A\u0011BAM\u0005Y\u0019\u0005.\u00198hK\u0016CXmY;uS>t7+\u001a:wS\u000e,'BA\u000f\u001f\u0003\u001d\u0019XM\u001d<jG\u0016T!a\b\u0011\u0002\u0013ad'/\u001a7fCN,'BA\u0011#\u0003%AXMY5bY\u0006\u00147OC\u0001$\u0003\r\u0019w.\\\u0002\u0001'\u0011\u0001a\u0005\f\u0019\u0011\u0005\u001dRS\"\u0001\u0015\u000b\u0003%\nQa]2bY\u0006L!a\u000b\u0015\u0003\r\u0005s\u0017PU3g!\tic&D\u0001\u001d\u0013\tyCDA\bDQ\u0006tw-\u001a)s_\u000e,7o]8s!\t\td'D\u00013\u0015\t\u0019D'A\u0003tY\u001a$$NC\u00016\u0003!9'/\u001b>{Y\u0016$\u0017BA\u001c3\u0005\u001daunZ4j]\u001e\fabY8n[\u0016tGoU3sm&\u001cW-F\u0001;!\ti3(\u0003\u0002=9\tq1i\\7nK:$8+\u001a:wS\u000e,\u0017aD2p[6,g\u000e^*feZL7-\u001a\u0011\u0002#\u0005$H/Y2i[\u0016tGoU3sm&\u001cW-F\u0001A!\ti\u0013)\u0003\u0002C9\t\t\u0012\t\u001e;bG\"lWM\u001c;TKJ4\u0018nY3\u0002%\u0005$H/Y2i[\u0016tGoU3sm&\u001cW\rI\u0001\u000fi\u0006\u001c8NU3q_NLGo\u001c:z+\u00051\u0005CA$K\u001b\u0005A%BA%\u001f\u0003)\u0011X\r]8tSR|'/_\u0005\u0003\u0017\"\u0013a\u0002V1tWJ+\u0007o\\:ji>\u0014\u00180A\buCN\\'+\u001a9pg&$xN]=!\u0003Q\tG\u000f^1dQ6,g\u000e\u001e*fa>\u001c\u0018\u000e^8ssV\tq\n\u0005\u0002H!&\u0011\u0011\u000b\u0013\u0002\u0015\u0003R$\u0018m\u00195nK:$(+\u001a9pg&$xN]=\u0002+\u0005$H/Y2i[\u0016tGOU3q_NLGo\u001c:zA\u0005\t\"/\u001a7fCN,'+\u001a9pg&$xN]=\u0016\u0003U\u0003\"a\u0012,\n\u0005]C%!\u0005*fY\u0016\f7/\u001a*fa>\u001c\u0018\u000e^8ss\u0006\u0011\"/\u001a7fCN,'+\u001a9pg&$xN]=!\u0003=\u0001\b.Y:f%\u0016\u0004xn]5u_JLX#A.\u0011\u0005\u001dc\u0016BA/I\u0005=\u0001\u0006.Y:f%\u0016\u0004xn]5u_JL\u0018\u0001\u00059iCN,'+\u001a9pg&$xN]=!\u0003e1\u0017mY3u%\u0016\u0004xn]5u_JLH)[:qCR\u001c\u0007.\u001a:\u0016\u0003\u0005\u0004\"a\u00122\n\u0005\rD%!\u0007$bG\u0016$(+\u001a9pg&$xN]=ESN\u0004\u0018\r^2iKJ\f!DZ1dKR\u0014V\r]8tSR|'/\u001f#jgB\fGo\u00195fe\u0002\n\u0001\"\u001a<f]R\u0014Uo]\u000b\u0002OB\u0011\u0001n[\u0007\u0002S*\u0011!NH\u0001\u0007KZ,g\u000e^:\n\u00051L'!\u0005-M%\u0016dW-Y:f\u000bZ,g\u000e\u001e\"vg\u0006IQM^3oi\n+8\u000fI\u0001\u0019I\u0016\u0004XM\u001c3f]\u000eLH+\u0019:hKR\u0014Vm]8mm\u0016\u0014X#\u00019\u0011\u0005\u001d\u000b\u0018B\u0001:I\u0005a!U\r]3oI\u0016t7-\u001f+be\u001e,GOU3t_24XM]\u0001\u001aI\u0016\u0004XM\u001c3f]\u000eLH+\u0019:hKR\u0014Vm]8mm\u0016\u0014\b%\u0001\u0004=S:LGO\u0010\u000b\u000bm^D\u0018P_>}{z|\bCA\u0017\u0001\u0011\u0015A4\u00031\u0001;\u0011\u0015q4\u00031\u0001A\u0011\u0015!5\u00031\u0001G\u0011\u0015i5\u00031\u0001P\u0011\u0015\u00196\u00031\u0001V\u0011\u0015I6\u00031\u0001\\\u0011\u0015y6\u00031\u0001b\u0011\u0015)7\u00031\u0001h\u0011\u0015q7\u00031\u0001q\u00031\t\u0007\u000f\u001d7z\u0007\"\fgnZ3t)\u0019\t)!a\u0003\u0002\u001cA\u0019q%a\u0002\n\u0007\u0005%\u0001F\u0001\u0003V]&$\bbBA\u0007)\u0001\u0007\u0011qB\u0001\bG\"\fgnZ3t!\u0011\t\t\"a\u0006\u000e\u0005\u0005M!bAA\u000b=\u00051Am\\7bS:LA!!\u0007\u0002\u0014\t91\t[1oO\u0016\u001c\bbBA\u000f)\u0001\u0007\u0011qD\u0001\u0005kN,'\u000f\u0005\u0003\u0002\"\u0005\u0015RBAA\u0012\u0015\r\tiBH\u0005\u0005\u0003O\t\u0019C\u0001\u0003Vg\u0016\u0014\bf\u0001\u000b\u0002,A!\u0011QFA\u001e\u001b\t\tyC\u0003\u0003\u00022\u0005M\u0012a\u0003;sC:\u001c\u0018m\u0019;j_:TA!!\u000e\u00028\u0005\u00191/\u001d7\u000b\u0007\u0005eb$\u0001\u0002eE&!\u0011QHA\u0018\u0005=I5\u000f\u0016:b]N\f7\r^5p]\u0006d\u0017!\u00049s_\u000e,7o\u001d$bG\u0016$8\u000f\u0006\u0003\u0002\u0006\u0005\r\u0003bBA\u0007+\u0001\u0007\u0011qB\u0001\u0010aJ|7-Z:t%\u0016dW-Y:fgR!\u0011QAA%\u0011\u001d\tiA\u0006a\u0001\u0003\u001f\tqbY8mY\u0016\u001cGoQ8n[\u0016tGo\u001d\u000b\u0007\u0003\u001f\n\u0019)!\"\u0011\u0011\u0005E\u0013qLA3\u0003WrA!a\u0015\u0002\\A\u0019\u0011Q\u000b\u0015\u000e\u0005\u0005]#bAA-I\u00051AH]8pizJ1!!\u0018)\u0003\u0019\u0001&/\u001a3fM&!\u0011\u0011MA2\u0005\ri\u0015\r\u001d\u0006\u0004\u0003;B\u0003\u0003BA\t\u0003OJA!!\u001b\u0002\u0014\t!A+Y:l!\u0019\ti'a\u001e\u0002~9!\u0011qNA:\u001d\u0011\t)&!\u001d\n\u0003%J1!!\u001e)\u0003\u001d\u0001\u0018mY6bO\u0016LA!!\u001f\u0002|\t\u00191+Z9\u000b\u0007\u0005U\u0004\u0006\u0005\u0003\u0002\u0012\u0005}\u0014\u0002BAA\u0003'\u0011qaQ8n[\u0016tG\u000fC\u0004\u0002\u000e]\u0001\r!a\u0004\t\u000f\u0005uq\u00031\u0001\u0002 \u0005\u0011\u0002O]8dKN\u001c\u0018\t\u001e;bG\"lWM\u001c;t)\u0011\t)!a#\t\u000f\u00055\u0001\u00041\u0001\u0002\u0010\u0005y\u0001O]8dKN\u001c8i\\7nK:$8\u000f\u0006\u0004\u0002\u0006\u0005E\u0015Q\u0013\u0005\b\u0003'K\u0002\u0019AA(\u00039\u0019w.\\7f]R\u001c()\u001f+bg.Dq!!\b\u001a\u0001\u0004\ty\"\u0001\u0007qe>\u001cWm]:UCN\\7\u000f\u0006\u0003\u0002\u0006\u0005m\u0005bBA\u00075\u0001\u0007\u0011q\u0002\u0015\u0004\u0001\u0005}\u0005\u0003BAQ\u0003_k!!a)\u000b\t\u0005\u0015\u0016qU\u0001\u000bgR,'/Z8usB,'\u0002BAU\u0003W\u000bqb\u001d9sS:<gM]1nK^|'o\u001b\u0006\u0003\u0003[\u000b1a\u001c:h\u0013\u0011\t\t,a)\u0003\u000fM+'O^5dK\u0002")
public class ChangeExecutionService
implements ChangeProcessor,
Logging {
    private final CommentService commentService;
    private final AttachmentService attachmentService;
    private final TaskRepository taskRepository;
    private final AttachmentRepository attachmentRepository;
    private final ReleaseRepository releaseRepository;
    private final PhaseRepository phaseRepository;
    private final FacetRepositoryDispatcher facetRepositoryDispatcher;
    private final XLReleaseEventBus eventBus;
    private final DependencyTargetResolver dependencyTargetResolver;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    @Override
    public void processPhases(Changes changes) {
        ChangeProcessor.processPhases$(this, changes);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        ChangeExecutionService changeExecutionService = this;
        synchronized (changeExecutionService) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        if (!this.bitmap$trans$0) {
            return this.grizzled$slf4j$Logging$$_logger$lzycompute();
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public CommentService commentService() {
        return this.commentService;
    }

    public AttachmentService attachmentService() {
        return this.attachmentService;
    }

    public TaskRepository taskRepository() {
        return this.taskRepository;
    }

    public AttachmentRepository attachmentRepository() {
        return this.attachmentRepository;
    }

    public ReleaseRepository releaseRepository() {
        return this.releaseRepository;
    }

    @Override
    public PhaseRepository phaseRepository() {
        return this.phaseRepository;
    }

    public FacetRepositoryDispatcher facetRepositoryDispatcher() {
        return this.facetRepositoryDispatcher;
    }

    public XLReleaseEventBus eventBus() {
        return this.eventBus;
    }

    public DependencyTargetResolver dependencyTargetResolver() {
        return this.dependencyTargetResolver;
    }

    @IsTransactional
    public void applyChanges(Changes changes, User user) {
        this.processFacets(changes);
        this.processAttachments(changes);
        this.processComments(this.collectComments(changes, user), user);
        this.processTasks(changes);
        this.processPhases(changes);
        this.processReleases(changes);
    }

    private void processFacets(Changes changes) {
        Set facets = ((IterableOnceOps)((IterableOps)CollectionConverters$.MODULE$.SetHasAsScala(changes.getUpdatedItems()).asScala().filter((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)ChangeExecutionService.$anonfun$processFacets$1(x$1)))).map((Function1 & Serializable)x$2 -> (Facet)x$2)).toSet();
        facets.foreach((Function1 & Serializable)facet -> ((FacetRepository.FacetTypeDispatcher)((Object)this.facetRepositoryDispatcher().liveRepository())).update((Facet)facet));
    }

    private void processReleases(Changes changes) {
        Set releases = ((IterableOnceOps)((IterableOps)CollectionConverters$.MODULE$.SetHasAsScala(changes.getUpdatedItems()).asScala().filter((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)ChangeExecutionService.$anonfun$processReleases$1(x$3)))).map((Function1 & Serializable)x$4 -> ((PlanItem)x$4).getRelease())).toSet();
        releases.foreach((Function1 & Serializable)release -> this.releaseRepository().update((Release)release));
    }

    private Map<Task, Seq<Comment>> collectComments(Changes changes, User user) {
        return CollectionConverters$.MODULE$.MapHasAsScala(changes.getCommentsByTask().asMap()).asScala().map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                Task task = (Task)tuple2._1();
                Collection commentTexts = (Collection)tuple2._2();
                Seq userComments = ((IterableOnceOps)CollectionConverters$.MODULE$.CollectionHasAsScala(commentTexts).asScala().map((Function1 & Serializable)x0$2 -> {
                    Tuple3 tuple3 = x0$2;
                    if (tuple3 != null) {
                        User u = (User)tuple3._1();
                        String text = (String)tuple3._2();
                        DateTime date = (DateTime)tuple3._3();
                        User actualUser = (User)Option$.MODULE$.apply((Object)u).getOrElse((Function0 & Serializable)() -> user);
                        return this.commentService().buildComment(task, text, actualUser.getName(), date.toDate(), CommentService.COMMENT_PREFIX_MANUAL, CommentService.COMMENT_SUFFIX);
                    }
                    throw new MatchError((Object)tuple3);
                })).toSeq();
                return new Tuple2((Object)task, (Object)userComments);
            }
            throw new MatchError((Object)tuple2);
        }).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    private void processAttachments(Changes changes) {
        CollectionConverters$.MODULE$.MapHasAsScala(changes.getAttachmentsByTask().asMap()).asScala().foreach((Function1 & Serializable)x0$1 -> {
            ChangeExecutionService.$anonfun$processAttachments$1(this, changes, x0$1);
            return BoxedUnit.UNIT;
        });
        CollectionConverters$.MODULE$.MapHasAsScala(changes.getLinkedAttachments().asMap()).asScala().foreach((Function1 & Serializable)x0$2 -> {
            ChangeExecutionService.$anonfun$processAttachments$4(this, x0$2);
            return BoxedUnit.UNIT;
        });
    }

    public void processComments(Map<Task, Seq<Comment>> commentsByTask, User user) {
        commentsByTask.foreach((Function1 & Serializable)x0$1 -> {
            ChangeExecutionService.$anonfun$processComments$1(this, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    private void processTasks(Changes changes) {
        Set tasks = ((IterableOnceOps)((IterableOps)CollectionConverters$.MODULE$.SetHasAsScala(changes.getUpdatedItems()).asScala().filter((Function1 & Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)ChangeExecutionService.$anonfun$processTasks$1(x$5)))).map((Function1 & Serializable)x$6 -> (Task)x$6)).toSet();
        tasks.collect((PartialFunction)new Serializable(this){
            private static final long serialVersionUID = 0L;
            private final /* synthetic */ ChangeExecutionService $outer;

            public final <A1 extends Task, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (A1 instanceof GateTask) {
                    GateTask gateTask = (GateTask)A1;
                    CollectionConverters$.MODULE$.ListHasAsScala(gateTask.getDependencies()).asScala().foreach((Function1 & Serializable)dependency -> {
                        $anonfun$processTasks$3.$anonfun$applyOrElse$1(this, dependency);
                        return BoxedUnit.UNIT;
                    });
                    return (B1)BoxedUnit.UNIT;
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(Task x1) {
                Task task = x1;
                return task instanceof GateTask;
            }

            public static final /* synthetic */ void $anonfun$applyOrElse$1($anonfun$processTasks$3 $this, Dependency dependency) {
                $this.$outer.dependencyTargetResolver().populateArchivedTargetId(dependency);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$1$adapted(com.xebialabs.xlrelease.service.ChangeExecutionService$$anonfun$processTasks$3 com.xebialabs.xlrelease.domain.Dependency )}, serializedLambda);
            }
        });
        this.taskRepository().batchUpdateTaskProperties((Set<Task>)tasks);
    }

    public static final /* synthetic */ boolean $anonfun$processFacets$1(ConfigurationItem x$1) {
        return x$1 instanceof Facet;
    }

    public static final /* synthetic */ boolean $anonfun$processReleases$1(ConfigurationItem x$3) {
        return x$3 instanceof PlanItem;
    }

    public static final /* synthetic */ void $anonfun$processAttachments$3(ChangeExecutionService $this, Task task$2, Attachment attachment$1, Changes changes$1, InputStream is) {
        Attachment attachmentAttached = $this.attachmentService().attachToRelease(task$2.getRelease(), attachment$1.getFile().getName(), attachment$1.getContentType(), is);
        if ($this.attachmentRepository().batchInsert(task$2.getRelease(), (Seq<Attachment>)new .colon.colon((Object)attachmentAttached, (List)Nil$.MODULE$))) {
            task$2.getAttachments().add(attachmentAttached);
            $this.eventBus().publish((XLReleaseEvent)new AttachmentCreatedEvent(task$2.getId(), attachmentAttached));
            v0 = BoxedUnit.UNIT;
        } else {
            changes$1.addComment(task$2, User.LOG_OUTPUT, "There was a problem adding the attachment. See xl-release.log");
            v0 = BoxesRunTime.boxToBoolean((boolean)task$2.getRelease().getAttachments().remove(attachmentAttached));
        }
        changes$1.update((ConfigurationItem)task$2.getRelease());
    }

    public static final /* synthetic */ void $anonfun$processAttachments$1(ChangeExecutionService $this, Changes changes$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            Task task = (Task)tuple2._1();
            Collection attachments = (Collection)tuple2._2();
            CollectionConverters$.MODULE$.CollectionHasAsScala(attachments).asScala().foreach((Function1 & Serializable)attachment -> {
                CloseableUtils$.MODULE$.using(attachment.getFile().getInputStream(), (Function1 & Serializable)is -> {
                    ChangeExecutionService.$anonfun$processAttachments$3($this, task$2, attachment, changes$1, is);
                    return BoxedUnit.UNIT;
                });
                return BoxedUnit.UNIT;
            });
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ void $anonfun$processAttachments$5(ChangeExecutionService $this, Task task$3, Attachment attachment) {
        Attachment loadedAttachment = $this.attachmentRepository().findById(attachment.getId());
        attachment.setFile(loadedAttachment.getFile());
        $this.eventBus().publish((XLReleaseEvent)new AttachmentCreatedEvent(task$3.getId(), attachment));
    }

    public static final /* synthetic */ void $anonfun$processAttachments$4(ChangeExecutionService $this, Tuple2 x0$2) {
        Tuple2 tuple2 = x0$2;
        if (tuple2 != null) {
            Task task = (Task)tuple2._1();
            Collection attachments = (Collection)tuple2._2();
            CollectionConverters$.MODULE$.CollectionHasAsScala(attachments).asScala().foreach((Function1 & Serializable)attachment -> {
                ChangeExecutionService.$anonfun$processAttachments$5($this, task, attachment);
                return BoxedUnit.UNIT;
            });
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ void $anonfun$processComments$1(ChangeExecutionService $this, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            Task task = (Task)tuple2._1();
            Seq comments = (Seq)tuple2._2();
            comments.foreach((Function1 & Serializable)comment -> $this.commentService().create(task, (Comment)comment));
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ boolean $anonfun$processTasks$1(ConfigurationItem x$5) {
        return x$5 instanceof Task;
    }

    public ChangeExecutionService(CommentService commentService, AttachmentService attachmentService, TaskRepository taskRepository, AttachmentRepository attachmentRepository, ReleaseRepository releaseRepository, PhaseRepository phaseRepository, FacetRepositoryDispatcher facetRepositoryDispatcher, XLReleaseEventBus eventBus, DependencyTargetResolver dependencyTargetResolver) {
        this.commentService = commentService;
        this.attachmentService = attachmentService;
        this.taskRepository = taskRepository;
        this.attachmentRepository = attachmentRepository;
        this.releaseRepository = releaseRepository;
        this.phaseRepository = phaseRepository;
        this.facetRepositoryDispatcher = facetRepositoryDispatcher;
        this.eventBus = eventBus;
        this.dependencyTargetResolver = dependencyTargetResolver;
        ChangeProcessor.$init$(this);
        Logging.$init$((Logging)this);
    }
}

