package com.xebialabs.xlrelease.script.builder

import com.xebialabs.xlrelease.configuration.TaskTimeoutSettings
import com.xebialabs.xlrelease.domain.Task
import com.xebialabs.xlrelease.script.{ScriptTimeoutContext, XlrScript, XlrScriptContext}

import java.time.Duration
import java.util.concurrent.ScheduledExecutorService

class TaskPreconditionScriptContextBuilder(task: Task,
                                           timeoutExecutor: ScheduledExecutorService,
                                           timeoutSettings: TaskTimeoutSettings) extends ScriptContextBuilder {
  withScriptApi().withLogger().withExecutionId(task.getExecutionId)
  withPythonSugar().withPythonGlobals().withPythonReleaseApi().withPythonUtilities()

  private val timeoutEnabled = timeoutSettings.isPreconditionTimeoutEnabled
  private val timeout = Duration.ofSeconds(timeoutSettings.getPreconditionTimeout.toLong)
  withTimeoutContext(new ScriptTimeoutContext(timeoutEnabled, timeoutExecutor, timeout, "Precondition script timed out."))

  override protected def doBuild(context: XlrScriptContext): Unit = {
    context.addDomainObjects(safe(task))

    val script = XlrScript.byContent(s"<precondition>${task.getType}[${task.getId}]", task.getPrecondition, wrap = true, checkPermissions = true)
    context.addScript(script)
  }

}