package com.xebialabs.xlrelease.actors.initializer

import com.xebialabs.deployit.ServerState
import com.xebialabs.xlrelease.service.{XlrServiceLifecycle, XlrServiceLifecycleOrder}
import org.springframework.stereotype.Component

import scala.jdk.CollectionConverters._

@Component
class SubscriptionInitializersLifecycleManager(subscriptionInitializers: java.util.List[_ <: SubscriptionInitializer])
  extends XlrServiceLifecycle {

  override def getOrder: Int = XlrServiceLifecycleOrder.SUBSCRIPTION_INITIALIZERS

  override def doStart(): Unit = {
    if (ServerState.getInstance().getCurrentMode == ServerState.Mode.MAINTENANCE) {
      logger.warn("[MAINTENANCE MODE] Webhook triggers - DISABLED")
    } else {
      subscriptionInitializers.asScala.sortBy(_.getOrder).foreach(subscriptionInitializer => {
        try {
          subscriptionInitializer.initialize()
        } catch {
          case e: Exception =>
            logger.error(s"Unable to initialize ${subscriptionInitializer.getClass.getName}", e)
            throw e
        }
      })
    }
  }

  override def doStop(): Unit = {
    //Nothing to stop
  }
}
