package com.xebialabs.xlrelease.scheduler.workers

import com.xebialabs.xlrelease.actors.ReleaseActorService
import com.xebialabs.xlrelease.user.User.SYSTEM
import grizzled.slf4j.Logger

trait TaskWorkerFailureLogic {
  def releaseActorService(): ReleaseActorService

  protected def logger: Logger

  def handleFailure(taskId: String, executionId: String, e: Throwable): Unit = {
    val message = s"Task [$taskId] with script execution [$executionId] was terminated due to: [$e]"
    logger.debug(message, e)
    releaseActorService().failTaskWithRetry(taskId, message, SYSTEM, Option.empty, executionId)
  }
}
