import inspect
import re

from org.springframework.security.core.context import SecurityContextHolder
from java.lang import RuntimeException, UnsupportedOperationException
from com.xebialabs.deployit.security import PermissionDeniedException
from com.xebialabs.xlrelease.security import XLReleasePermissions
from com.xebialabs.xlrelease.utils import DateVariableUtils

# Those imports make API objects available in all user scripts so they don't have to
# import classes by themselves
from com.xebialabs.xlrelease.api.v1.forms import Comment
from com.xebialabs.xlrelease.api.v1.forms import Condition
from com.xebialabs.xlrelease.api.v1.forms import CreateRelease
from com.xebialabs.xlrelease.api.v1.forms import StartRelease
from com.xebialabs.xlrelease.api.v1.forms import StartTask
from com.xebialabs.xlrelease.api.v1.forms import UserAccount
from com.xebialabs.xlrelease.api.v1.forms import Variable

def run_as_wrapper(attribute):
    def wrapped_function(*args):
        if SecurityContextHolder.getContext().getAuthentication() is None:
            raise RuntimeException("A 'Run automated tasks as user' and 'Password' properties has to be set in order to use Digital.ai Release's API")
        return attribute(*args)

    return wrapped_function

def run_as_wrapper_without_permissions_check(attribute):
    def wrapped_function(*args):
        return attribute(*args)

    return wrapped_function


def vars_wrapper(exception, attribute):
    def wrapped_function(*args):
        try:
            return attribute(*args)
        except UnsupportedOperationException:
            raise exception

    return wrapped_function

def dateTime(dateStr):
    return DateVariableUtils.parseDate(dateStr)

def set_started_from_task_id(create_release):
    script_task_id = task.getId()
    if script_task_id and not create_release.getStartedFromTaskId():
        create_release.setStartedFromTaskId(script_task_id)

def wrap_create_release_method(template_api):
    original_create = template_api.create

    def wrapped_create(*args, **kwargs):
        for arg in args:
            if isinstance(arg, CreateRelease):
                set_started_from_task_id(arg)
        return original_create(*args, **kwargs)

    template_api.create = wrapped_create

class SugarifiedResource:
    def __init__(self, resource, pointcut=inspect.isfunction, wrapper=run_as_wrapper):
        self.resource = resource
        self.pointcut = pointcut
        self.wrapper = wrapper

    def __getattr__(self, name):
        wrapped_attribute = wrap(getattr(self.resource, name))
        if self.pointcut(wrapped_attribute):
            return self.wrapper(wrapped_attribute)
        return wrapped_attribute


for k in globals().keys():
    if (re.match("_(.*)Api", k)):
        v = globals()[k]
        if k != "_taskReportingApi":
            globals()[k[1:]] = SugarifiedResource(v)
        else:
            globals()[k[1:]] = SugarifiedResource(v, inspect.isfunction, run_as_wrapper_without_permissions_check)

if '_releaseVariables' in globals():
    releaseVariables = SugarifiedResource(_releaseVariables, lambda _: True, lambda attrib: vars_wrapper(RuntimeException("Set a 'Run automated tasks as user' with release#edit permissions in order to modify release variables"), attrib))
if '_globalVariables' in globals():
    ex1 = PermissionDeniedException.forPermission(XLReleasePermissions.EDIT_GLOBAL_VARIABLES, None)
    ex1.add("\nSet a 'Run automated tasks as user' with global_variables#edit permissions in order to modify global variables")
    globalVariables = SugarifiedResource(_globalVariables, lambda _: True, lambda attrib: vars_wrapper(ex1, attrib))
if '_folderVariables' in globals():
    ex2 = PermissionDeniedException.forPermission(XLReleasePermissions.EDIT_FOLDER_VARIABLES, release.findFolderId())
    ex2.add("\nSet a 'Run automated tasks as user' with folder#edit permissions in order to modify folder variables")
    folderVariables = SugarifiedResource(_folderVariables, lambda _: True, lambda attrib: vars_wrapper(ex2, attrib))

if '_valueProvider' in globals():
    valueProvider = wrap(_valueProvider)

# Wrap the create method of templateApi
if 'templateApi' in globals():
    wrap_create_release_method(templateApi)
