/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.views.converters;

import com.xebialabs.xlrelease.api.internal.EffectiveSecurity;
import com.xebialabs.xlrelease.api.internal.EffectiveSecurityDecorator;
import com.xebialabs.xlrelease.domain.CustomScriptTask;
import com.xebialabs.xlrelease.domain.Phase;
import com.xebialabs.xlrelease.domain.PlanItem;
import com.xebialabs.xlrelease.domain.PythonScript;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.Task;
import com.xebialabs.xlrelease.domain.TaskGroup;
import com.xebialabs.xlrelease.search.ReleaseSearchResult;
import com.xebialabs.xlrelease.variable.VariableHelper;
import com.xebialabs.xlrelease.views.Flag;
import com.xebialabs.xlrelease.views.PhaseOverviewView;
import com.xebialabs.xlrelease.views.ReleaseOverviewSearchView;
import com.xebialabs.xlrelease.views.ReleaseOverviewView;
import com.xebialabs.xlrelease.views.TaskOverviewView;
import com.xebialabs.xlrelease.views.converters.BaseReleaseConverter;
import com.xebialabs.xlrelease.views.converters.PlanItemConverter;
import com.xebialabs.xlrelease.views.converters.ReleaseExtensionsViewConverter;
import com.xebialabs.xlrelease.views.converters.UserViewConverter;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ReleaseOverviewConverter
extends BaseReleaseConverter
implements PlanItemConverter {
    public static final Logger logger = LoggerFactory.getLogger(ReleaseOverviewConverter.class);
    private final UserViewConverter userViewConverter;
    private final ReleaseExtensionsViewConverter releaseExtensionsViewConverter;

    public ReleaseOverviewConverter(UserViewConverter userViewConverter, ReleaseExtensionsViewConverter releaseExtensionsViewConverter) {
        this.userViewConverter = userViewConverter;
        this.releaseExtensionsViewConverter = releaseExtensionsViewConverter;
    }

    public ReleaseOverviewSearchView toOverviewSearchView(ReleaseSearchResult releaseSearchResult, List<String> properties, int depth, List<String> extensions) {
        List<ReleaseOverviewView> views = releaseSearchResult.getReleases().stream().map(r -> this.toOverviewView((Release)r, properties, extensions, depth)).collect(Collectors.toList());
        return new ReleaseOverviewSearchView(releaseSearchResult.getPage(), views);
    }

    public ReleaseOverviewView toOverviewView(Release release, List<String> properties, List<String> extensions, int depth) {
        ReleaseOverviewView view = new ReleaseOverviewView();
        this.populatePlanItemView(view, (PlanItem)release);
        view.setStatus(release.getStatus());
        view.setReleaseFlag(Flag.toItemFlag((PlanItem)release));
        view.setFlag(Flag.toFlag(release));
        view.setArchived(release.isArchived());
        view.setSecurity((EffectiveSecurity)release.get$metadata().get(EffectiveSecurityDecorator.EFFECTIVE_SECURITY()));
        view.setTags(release.getTags());
        view.setKind(release.getKind());
        if (release.hasOwner()) {
            view.setOwner(this.userViewConverter.toUserView(release.getOwner()));
        }
        this.populateSyntheticProperties(release, view, properties);
        if (depth <= 1) {
            return view;
        }
        if (release.hasCurrentPhase()) {
            Phase currentPhase = release.getCurrentPhase();
            view.setCurrentPhase(currentPhase.getTitle());
        }
        if (!release.isTemplate()) {
            Map usedStringVariables = VariableHelper.getUsedStringVariables((PlanItem)release);
            view.setVariables(usedStringVariables);
        }
        this.populateExtensions(release, view, extensions);
        if (depth <= 2) {
            return view;
        }
        if (release.getPhases() != null) {
            view.setPhases(release.getPhases().stream().map(this::toOverviewPhase).collect(Collectors.toList()));
        }
        return view;
    }

    private PhaseOverviewView toOverviewPhase(Phase phase) {
        PhaseOverviewView view = new PhaseOverviewView();
        this.populatePlanItemView(view, (PlanItem)phase);
        view.setStatus(phase.getStatus());
        view.setColor(phase.getColor());
        int taskFailureCount = 0;
        int taskFlaggedCount = 0;
        int taskDelayCount = 0;
        if (phase.getTasks() != null) {
            view.setTasks(phase.getTasks().stream().map(this::toOverviewTask).collect(Collectors.toList()));
            for (Task task : phase.getAllTasks()) {
                if (task.hasBeenDelayed()) {
                    ++taskDelayCount;
                }
                if (task.hasBeenFlagged()) {
                    ++taskFlaggedCount;
                }
                if (task.isTaskGroup()) continue;
                taskFailureCount += task.getFailuresCount();
            }
            view.setTaskDelayCount(taskDelayCount);
            view.setTaskFlaggedCount(taskFlaggedCount);
            view.setTaskFailureCount(taskFailureCount);
        }
        return view;
    }

    private TaskOverviewView toOverviewTask(Task task) {
        TaskOverviewView view = new TaskOverviewView();
        this.populatePlanItemView(view, (PlanItem)task);
        view.setStatus(task.getStatus());
        view.setTags(task.getTags());
        if (task instanceof TaskGroup) {
            List<TaskOverviewView> tasks = ((TaskGroup)task).getTasks().stream().map(this::toOverviewTask).collect(Collectors.toList());
            view.setTasks(tasks);
        } else if (task instanceof CustomScriptTask) {
            CustomScriptTask customTaskView = (CustomScriptTask)task;
            PythonScript pythonScript = customTaskView.getPythonScript();
            view.setColor(pythonScript.getTaskColor());
            view.setCustomIconLocation(pythonScript.getIconLocation());
            view.setCustomIconClass(pythonScript.getIconClass());
        }
        return view;
    }

    @Override
    public ReleaseExtensionsViewConverter getReleaseExtensionsViewConverter() {
        return this.releaseExtensionsViewConverter;
    }
}

