/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.support.tools;

import com.xebialabs.deployit.ServerConfiguration;
import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.license.service.LicenseService;
import com.xebialabs.xlrelease.actors.ReleaseActorService;
import com.xebialabs.xlrelease.actors.utils.ReleaseActorLifecycleUtils;
import com.xebialabs.xlrelease.analytics.service.AnalyticsService;
import com.xebialabs.xlrelease.analytics.service.AnalyticsService$;
import com.xebialabs.xlrelease.db.ArchivedReleases;
import com.xebialabs.xlrelease.domain.status.TaskStatus;
import com.xebialabs.xlrelease.exception.LogFriendlyNotFoundException;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.repository.MetadataRepository;
import com.xebialabs.xlrelease.repository.ReleaseRepository;
import com.xebialabs.xlrelease.service.ArchivingService;
import com.xebialabs.xlrelease.support.tools.SupportUtilitiesActorExtensionHandlerFactory;
import com.xebialabs.xlrelease.views.LicenseView;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import java.util.concurrent.TimeUnit;
import org.slf4j.Marker;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import scala.Function0;
import scala.Function1;
import scala.concurrent.duration.FiniteDuration$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@Service
@ScalaSignature(bytes="\u0006\u0005\u0005]e\u0001\u0002\r\u001a\u0001\u0011B\u0001b\r\u0001\u0003\u0006\u0004%\t\u0001\u000e\u0005\tw\u0001\u0011\t\u0011)A\u0005k!AA\b\u0001BC\u0002\u0013\u0005Q\b\u0003\u0005E\u0001\t\u0005\t\u0015!\u0003?\u0011!)\u0005A!b\u0001\n\u00031\u0005\u0002\u0003&\u0001\u0005\u0003\u0005\u000b\u0011B$\t\u0011-\u0003!Q1A\u0005\u00021C\u0001b\u0015\u0001\u0003\u0002\u0003\u0006I!\u0014\u0005\t)\u0002\u0011)\u0019!C\u0001+\"Aa\f\u0001B\u0001B\u0003%a\u000b\u0003\u0005`\u0001\t\u0005\t\u0015!\u0003a\u0011!!\u0007A!b\u0001\n\u0003)\u0007\u0002\u00037\u0001\u0005\u0003\u0005\u000b\u0011\u00024\t\u00115\u0004!Q1A\u0005\u00029D\u0001B\u001e\u0001\u0003\u0002\u0003\u0006Ia\u001c\u0005\to\u0002\u0011)\u0019!C\u0001q\"I\u0011\u0011\u0001\u0001\u0003\u0002\u0003\u0006I!\u001f\u0005\b\u0003\u0007\u0001A\u0011AA\u0003\u0011\u001d\tY\u0004\u0001C\u0001\u0003{Aq!a\u001d\u0001\t\u0003\t)\bC\u0004\u0002|\u0001!\t!! \t\u000f\u0005\u0005\u0005\u0001\"\u0001\u0002\u0004\"9\u0011Q\u0011\u0001\u0005\u0002\u0005\u001d%\u0001E*vaB|'\u000f^+uS2LG/[3t\u0015\tQ2$A\u0003u_>d7O\u0003\u0002\u001d;\u000591/\u001e9q_J$(B\u0001\u0010 \u0003%AHN]3mK\u0006\u001cXM\u0003\u0002!C\u0005I\u00010\u001a2jC2\f'm\u001d\u0006\u0002E\u0005\u00191m\\7\u0004\u0001M\u0019\u0001!J\u0016\u0011\u0005\u0019JS\"A\u0014\u000b\u0003!\nQa]2bY\u0006L!AK\u0014\u0003\r\u0005s\u0017PU3g!\ta\u0013'D\u0001.\u0015\tqs&A\u0003tY\u001a$$NC\u00011\u0003!9'/\u001b>{Y\u0016$\u0017B\u0001\u001a.\u0005\u001daunZ4j]\u001e\f\u0001#\u0019:dQ&4\u0018N\\4TKJ4\u0018nY3\u0016\u0003U\u0002\"AN\u001d\u000e\u0003]R!\u0001O\u000f\u0002\u000fM,'O^5dK&\u0011!h\u000e\u0002\u0011\u0003J\u001c\u0007.\u001b<j]\u001e\u001cVM\u001d<jG\u0016\f\u0011#\u0019:dQ&4\u0018N\\4TKJ4\u0018nY3!\u0003E\u0011X\r\\3bg\u0016\u0014V\r]8tSR|'/_\u000b\u0002}A\u0011qHQ\u0007\u0002\u0001*\u0011\u0011)H\u0001\u000be\u0016\u0004xn]5u_JL\u0018BA\"A\u0005E\u0011V\r\\3bg\u0016\u0014V\r]8tSR|'/_\u0001\u0013e\u0016dW-Y:f%\u0016\u0004xn]5u_JL\b%\u0001\nnKR\fG-\u0019;b%\u0016\u0004xn]5u_JLX#A$\u0011\u0005}B\u0015BA%A\u0005IiU\r^1eCR\f'+\u001a9pg&$xN]=\u0002'5,G/\u00193bi\u0006\u0014V\r]8tSR|'/\u001f\u0011\u0002!\u0005\u00148\r[5wK\u0012\u0014V\r\\3bg\u0016\u001cX#A'\u0011\u00059\u000bV\"A(\u000b\u0005Ak\u0012A\u00013c\u0013\t\u0011vJ\u0001\tBe\u000eD\u0017N^3e%\u0016dW-Y:fg\u0006\t\u0012M]2iSZ,GMU3mK\u0006\u001cXm\u001d\u0011\u00025I,G.Z1tK\u0006\u001bGo\u001c:MS\u001a,7-_2mKV#\u0018\u000e\\:\u0016\u0003Y\u0003\"a\u0016/\u000e\u0003aS!!\u0017.\u0002\u000bU$\u0018\u000e\\:\u000b\u0005mk\u0012AB1di>\u00148/\u0003\u0002^1\nQ\"+\u001a7fCN,\u0017i\u0019;pe2Kg-Z2zG2,W\u000b^5mg\u0006Y\"/\u001a7fCN,\u0017i\u0019;pe2Kg-Z2zG2,W\u000b^5mg\u0002\n1C]3mK\u0006\u001cX-Q2u_J\u001cVM\u001d<jG\u0016\u0004\"!\u00192\u000e\u0003iK!a\u0019.\u0003'I+G.Z1tK\u0006\u001bGo\u001c:TKJ4\u0018nY3\u0002'M,'O^3s\u0007>tg-[4ve\u0006$\u0018n\u001c8\u0016\u0003\u0019\u0004\"a\u001a6\u000e\u0003!T!![\u0010\u0002\u0011\u0011,\u0007\u000f\\8zSRL!a\u001b5\u0003'M+'O^3s\u0007>tg-[4ve\u0006$\u0018n\u001c8\u0002)M,'O^3s\u0007>tg-[4ve\u0006$\u0018n\u001c8!\u00039a\u0017nY3og\u0016\u001cVM\u001d<jG\u0016,\u0012a\u001c\t\u0003aRl\u0011!\u001d\u0006\u0003qIT!a]\u0010\u0002\u000f1L7-\u001a8tK&\u0011Q/\u001d\u0002\u000f\u0019&\u001cWM\\:f'\u0016\u0014h/[2f\u0003=a\u0017nY3og\u0016\u001cVM\u001d<jG\u0016\u0004\u0013\u0001E1oC2LH/[2t'\u0016\u0014h/[2f+\u0005I\bC\u0001>\u007f\u001b\u0005Y(B\u0001\u001d}\u0015\tiX$A\u0005b]\u0006d\u0017\u0010^5dg&\u0011qp\u001f\u0002\u0011\u0003:\fG.\u001f;jGN\u001cVM\u001d<jG\u0016\f\u0011#\u00198bYf$\u0018nY:TKJ4\u0018nY3!\u0003\u0019a\u0014N\\5u}Q!\u0012qAA\u0006\u0003\u001b\ty!!\u0005\u0002\u0014\u0005U\u0011qCA\r\u00037\u00012!!\u0003\u0001\u001b\u0005I\u0002\"B\u001a\u0013\u0001\u0004)\u0004\"\u0002\u001f\u0013\u0001\u0004q\u0004\"B#\u0013\u0001\u00049\u0005\"B&\u0013\u0001\u0004i\u0005\"\u0002+\u0013\u0001\u00041\u0006\"B0\u0013\u0001\u0004\u0001\u0007\"\u00023\u0013\u0001\u00041\u0007\"B7\u0013\u0001\u0004y\u0007\"B<\u0013\u0001\u0004I\bf\u0001\n\u0002 A!\u0011\u0011EA\u001c\u001b\t\t\u0019C\u0003\u0003\u0002&\u0005\u001d\u0012AC1o]>$\u0018\r^5p]*!\u0011\u0011FA\u0016\u0003\u001d1\u0017m\u0019;pefTA!!\f\u00020\u0005)!-Z1og*!\u0011\u0011GA\u001a\u0003=\u0019\bO]5oO\u001a\u0014\u0018-\\3x_J\\'BAA\u001b\u0003\ry'oZ\u0005\u0005\u0003s\t\u0019CA\u0005BkR|w/\u001b:fI\u0006\u0001R\u000f\u001d3bi\u0016$\u0016m]6Ti\u0006$Xo\u001d\u000b\u0007\u0003\u007f\t)%a\u0018\u0011\u0007\u0019\n\t%C\u0002\u0002D\u001d\u0012A!\u00168ji\"9\u0011qI\nA\u0002\u0005%\u0013A\u0002;bg.LE\r\u0005\u0003\u0002L\u0005ec\u0002BA'\u0003+\u00022!a\u0014(\u001b\t\t\tFC\u0002\u0002T\r\na\u0001\u0010:p_Rt\u0014bAA,O\u00051\u0001K]3eK\u001aLA!a\u0017\u0002^\t11\u000b\u001e:j]\u001eT1!a\u0016(\u0011\u001d\t\tg\u0005a\u0001\u0003G\n\u0011B\\3x'R\fG/^:\u0011\t\u0005\u0015\u0014qN\u0007\u0003\u0003ORA!!\u001b\u0002l\u000511\u000f^1ukNT1!!\u001c\u001e\u0003\u0019!w.\\1j]&!\u0011\u0011OA4\u0005)!\u0016m]6Ti\u0006$Xo]\u0001\u0012O\u0016$(+\u001a7fCN,7i\u001c8uK:$H\u0003BA%\u0003oBq!!\u001f\u0015\u0001\u0004\tI%A\u0005sK2,\u0017m]3JI\u0006iA-\u001a7fi\u0016\u0014V\r\\3bg\u0016$B!a\u0010\u0002\u0000!9\u0011\u0011P\u000bA\u0002\u0005%\u0013!E;qI\u0006$X-\u00118bYf$\u0018nY:JIR\u0011\u0011qH\u0001\u0016O\u0016$8)\u001e:sK:$\u0018I\\1msRL7m]%e+\t\tI\u0005K\u0002\u0001\u0003\u0017\u0003B!!$\u0002\u00146\u0011\u0011q\u0012\u0006\u0005\u0003#\u000by#\u0001\u0006ti\u0016\u0014Xm\u001c;za\u0016LA!!&\u0002\u0010\n91+\u001a:wS\u000e,\u0007")
public class SupportUtilities
implements Logging {
    private final ArchivingService archivingService;
    private final ReleaseRepository releaseRepository;
    private final MetadataRepository metadataRepository;
    private final ArchivedReleases archivedReleases;
    private final ReleaseActorLifecycleUtils releaseActorLifecycleUtils;
    private final ReleaseActorService releaseActorService;
    private final ServerConfiguration serverConfiguration;
    private final LicenseService licenseService;
    private final AnalyticsService analyticsService;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        SupportUtilities supportUtilities = this;
        synchronized (supportUtilities) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        if (!this.bitmap$trans$0) {
            return this.grizzled$slf4j$Logging$$_logger$lzycompute();
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public ArchivingService archivingService() {
        return this.archivingService;
    }

    public ReleaseRepository releaseRepository() {
        return this.releaseRepository;
    }

    public MetadataRepository metadataRepository() {
        return this.metadataRepository;
    }

    public ArchivedReleases archivedReleases() {
        return this.archivedReleases;
    }

    public ReleaseActorLifecycleUtils releaseActorLifecycleUtils() {
        return this.releaseActorLifecycleUtils;
    }

    public ServerConfiguration serverConfiguration() {
        return this.serverConfiguration;
    }

    public LicenseService licenseService() {
        return this.licenseService;
    }

    public AnalyticsService analyticsService() {
        return this.analyticsService;
    }

    public void updateTaskStatus(String taskId, TaskStatus newStatus) {
        String releaseId = Ids.releaseIdFrom((String)taskId);
        Checks.checkArgument((boolean)this.releaseRepository().exists(releaseId), (String)("Release [" + releaseId + "] not found"), (Object[])new Object[0]);
        this.releaseActorService.executeCommand(taskId, new SupportUtilitiesActorExtensionHandlerFactory.ForceTaskStatus(taskId, newStatus));
    }

    public String getReleaseContent(String releaseId) {
        if (this.releaseRepository().exists(releaseId)) {
            return this.releaseRepository().getReleaseJson(releaseId);
        }
        return (String)this.archivedReleases().getRelease(releaseId, this.archivedReleases().getRelease$default$2()).getOrElse((Function0 & Serializable)() -> {
            throw new LogFriendlyNotFoundException("Release [" + releaseId + "] not found", new Object[0]);
        });
    }

    public void deleteRelease(String releaseId) {
        String string;
        Checks.checkArgument((this.releaseRepository().exists(releaseId) || this.archivedReleases().exists(releaseId) ? 1 : 0) != 0, (String)("Release [" + releaseId + "] not found"), (Object[])new Object[0]);
        try {
            string = this.releaseActorLifecycleUtils().terminateReleaseActorAndAwait(releaseId, FiniteDuration$.MODULE$.apply(5L, TimeUnit.SECONDS));
        }
        catch (Exception e) {
            this.logger().error((Function0 & Serializable)() -> "Could not terminate release actor " + releaseId + " within timeout", (Function0 & Serializable)() -> e);
            string = BoxedUnit.UNIT;
        }
        this.archivedReleases().deleteReleaseFromArchive(releaseId);
        if (this.releaseRepository().exists(releaseId)) {
            try {
                this.archivingService().archiveAllIncomingDependencies(releaseId);
            }
            catch (Exception e) {
                this.logger().error((Function0 & Serializable)() -> "Could not archive incoming dependencies to " + releaseId, (Function0 & Serializable)() -> e);
            }
            this.releaseRepository().delete(releaseId, false);
            return;
        }
    }

    public void updateAnalyticsId() {
        LicenseView licenseView = new LicenseView(this.licenseService().getLicense());
        this.analyticsService().updateAccountId(licenseView.getLicensedTo(), this.serverConfiguration().getServerUrl());
    }

    public String getCurrentAnalyticsId() {
        return (String)this.metadataRepository().getEntry(AnalyticsService$.MODULE$.ANALYTICS_ID()).map((Function1 & Serializable)x$1 -> x$1.value()).getOrElse((Function0 & Serializable)() -> "");
    }

    @Autowired
    public SupportUtilities(ArchivingService archivingService, ReleaseRepository releaseRepository, MetadataRepository metadataRepository, ArchivedReleases archivedReleases, ReleaseActorLifecycleUtils releaseActorLifecycleUtils, ReleaseActorService releaseActorService, ServerConfiguration serverConfiguration, LicenseService licenseService, AnalyticsService analyticsService) {
        this.archivingService = archivingService;
        this.releaseRepository = releaseRepository;
        this.metadataRepository = metadataRepository;
        this.archivedReleases = archivedReleases;
        this.releaseActorLifecycleUtils = releaseActorLifecycleUtils;
        this.releaseActorService = releaseActorService;
        this.serverConfiguration = serverConfiguration;
        this.licenseService = licenseService;
        this.analyticsService = analyticsService;
        Logging.$init$((Logging)this);
    }
}

