/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.service;

import com.xebialabs.xlrelease.config.XlrConfig;
import com.xebialabs.xlrelease.utils.FileContentValidation;
import com.xebialabs.xlrelease.utils.UploadSettings;
import java.io.InputStream;
import org.apache.tika.detect.DefaultDetector;
import org.springframework.stereotype.Component;
import scala.util.Try;

@Component
public class FileContentValidator {
    private final DefaultDetector tikaDetector = new DefaultDetector();
    private final UploadSettings uploadSettings;

    public FileContentValidator() {
        XlrConfig xlrConfig = XlrConfig.getInstance();
        this.uploadSettings = new UploadSettings(xlrConfig.server().upload().shouldAnalyzeContent(), xlrConfig.server().upload().allowedFileTypes());
    }

    public Try<InputStream> validate(String filename, InputStream in) {
        return FileContentValidation.filter(this.tikaDetector, this.uploadSettings, filename, in);
    }
}

